/*
 * Decompiled with CFR 0.152.
 */
package com.github.melin.superior.sql.parser.util;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/github/melin/superior/sql/parser/util/DateUtils;", "", "()V", "getCurrentDateTime", "", "superior-sql-parser"})
public final class DateUtils {
    @NotNull
    public static final DateUtils INSTANCE = new DateUtils();

    private DateUtils() {
    }

    @NotNull
    public final String getCurrentDateTime() {
        try {
            LocalDateTime ldt = LocalDateTime.ofInstant(new Date().toInstant(), ZoneId.systemDefault());
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
            String string = ldt.format(format);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ldt.format(format)");
            return string;
        }
        catch (DateTimeException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

