/*
 * Decompiled with CFR 0.152.
 */
package com.github.melin.superior.sql.parser.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/github/melin/superior/sql/parser/util/StringUtil;", "", "()V", "cleanBackQuote", "", "value", "cleanQuote", "parseDataType", "type", "superior-sql-parser"})
public final class StringUtil {
    @NotNull
    public static final StringUtil INSTANCE = new StringUtil();

    private StringUtil() {
    }

    @NotNull
    public final String cleanQuote(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String result = value;
        if (StringUtils.startsWith((CharSequence)result, (CharSequence)"'") && StringUtils.endsWith((CharSequence)result, (CharSequence)"'")) {
            String string = StringUtils.substring((String)result, (int)1, (int)-1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(result, 1, -1)");
            result = string;
        }
        if (StringUtils.startsWith((CharSequence)result, (CharSequence)"\"") && StringUtils.endsWith((CharSequence)result, (CharSequence)"\"")) {
            String string = StringUtils.substring((String)result, (int)1, (int)-1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(result, 1, -1)");
            result = string;
        }
        return result;
    }

    @NotNull
    public final String cleanBackQuote(@Nullable String value) {
        if (value == null) {
            return "";
        }
        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"`") && StringUtils.endsWith((CharSequence)value, (CharSequence)"`")) {
            String string = StringUtils.substring((String)value, (int)1, (int)-1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(value, 1, -1)");
            return string;
        }
        return value;
    }

    @NotNull
    public final String parseDataType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String value = StringUtils.startsWith((CharSequence)type, (CharSequence)"TOK_") ? StringUtils.substringAfter((String)type, (String)"TOK_") : type;
        String string = StringUtils.lowerCase((String)value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lowerCase(value)");
        return string;
    }
}

