/*
 * Decompiled with CFR 0.152.
 */
package com.gobrs.async.core.autoconfig;

import com.gobrs.async.core.config.GobrsAsyncRule;
import com.gobrs.async.core.config.GobrsConfig;
import com.gobrs.async.core.property.GobrsAsyncProperties;
import com.gobrs.async.core.property.LogConfig;
import com.gobrs.async.core.property.RuleConfig;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GobrsPropertyAutoConfiguration {
    @Bean
    public GobrsConfig gobrsConfig(GobrsAsyncProperties properties) {
        GobrsConfig gobrsConfig = new GobrsConfig();
        gobrsConfig.setEnable(properties.isEnable());
        gobrsConfig.setSplit(properties.getSplit());
        gobrsConfig.setPoint(properties.getPoint());
        gobrsConfig.setParamContext(gobrsConfig.isParamContext());
        gobrsConfig.setTimeout(properties.getTimeout());
        gobrsConfig.setRelyDepend(properties.isRelyDepend());
        gobrsConfig.setTimeoutCoreSize(properties.getTimeoutCoreSize());
        this.threadPool(properties, gobrsConfig);
        List<RuleConfig> rules = properties.getRules();
        List rList = rules.stream().map(x -> {
            GobrsAsyncRule r = new GobrsAsyncRule();
            LogConfig logConfig = x.getLogConfig();
            if (Objects.nonNull(logConfig)) {
                r.setErrLogabled(logConfig.getErrLogabled());
                r.setCostLogabled(logConfig.getCostLogabled());
            }
            r.setCatchable(x.isCatchable());
            r.setName(x.getName());
            r.setContent(x.getContent());
            r.setTaskInterrupt(x.isTaskInterrupt());
            r.setTransaction(x.isTransaction());
            return r;
        }).collect(Collectors.toList());
        gobrsConfig.setRules(rList);
        return gobrsConfig;
    }

    private void threadPool(GobrsAsyncProperties properties, GobrsConfig gobrsConfig) {
        GobrsAsyncProperties.ThreadPool threadPool = properties.getThreadPool();
        if (Objects.nonNull(threadPool)) {
            GobrsConfig.ThreadPool tp = new GobrsConfig.ThreadPool();
            tp.setCorePoolSize(threadPool.getCorePoolSize().intValue());
            tp.setMaxPoolSize(threadPool.getMaxPoolSize().intValue());
            tp.setKeepAliveTime(threadPool.getKeepAliveTime().longValue());
            tp.setTimeUnit(threadPool.getTimeUnit());
            tp.setExecuteTimeOut(threadPool.getExecuteTimeOut().longValue());
            tp.setCapacity(threadPool.getCapacity().intValue());
            tp.setWorkQueue(threadPool.getWorkQueue());
            tp.setThreadNamePrefix(threadPool.getThreadNamePrefix());
            tp.setAllowCoreThreadTimeOut(threadPool.getAllowCoreThreadTimeOut());
            tp.setRejectedExecutionHandler(threadPool.getRejectedExecutionHandler());
            gobrsConfig.setThreadPool(tp);
        }
    }
}

