/*
 * Decompiled with CFR 0.152.
 */
package com.gobrs.async.core.property;

import com.gobrs.async.core.common.def.DefaultConfig;
import com.gobrs.async.core.property.GobbrsPropertySourceFactory;
import com.gobrs.async.core.property.PlatformConfig;
import com.gobrs.async.core.property.RuleConfig;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="gobrs.async.config", ignoreInvalidFields=false)
@PropertySource(value={"classpath:config/gobrs.yaml", "classpath:config/gobrs.yml", "classpath:config/gobrs.properties"}, ignoreResourceNotFound=false, factory=GobbrsPropertySourceFactory.class)
@Component
public class GobrsAsyncProperties {
    public static final String PREFIX = "gobrs.async.config";
    private boolean enable;
    private List<RuleConfig> rules;
    private PlatformConfig platform;
    private String split = ";";
    private String point = "->";
    private ThreadPool threadPool;
    private Integer timeoutCoreSize;
    private boolean paramContext = true;
    private boolean catchable;
    private long timeout = 3000L;
    private boolean relyDepend = false;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getSplit() {
        return this.split;
    }

    public void setSplit(String split) {
        this.split = split;
    }

    public String getPoint() {
        return this.point;
    }

    public void setPoint(String point) {
        this.point = point;
    }

    public List<RuleConfig> getRules() {
        return this.rules;
    }

    public void setRules(List<RuleConfig> rules) {
        this.rules = rules;
    }

    public boolean isRelyDepend() {
        return this.relyDepend;
    }

    public void setRelyDepend(boolean relyDepend) {
        this.relyDepend = relyDepend;
    }

    public boolean isParamContext() {
        return this.paramContext;
    }

    public void setParamContext(boolean paramContext) {
        this.paramContext = paramContext;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Integer getTimeoutCoreSize() {
        return this.timeoutCoreSize;
    }

    public void setTimeoutCoreSize(Integer timeoutCoreSize) {
        this.timeoutCoreSize = timeoutCoreSize;
    }

    public PlatformConfig getPlatform() {
        return this.platform;
    }

    public void setPlatform(PlatformConfig platform) {
        this.platform = platform;
    }

    public boolean isCatchable() {
        return this.catchable;
    }

    public void setCatchable(boolean catchable) {
        this.catchable = catchable;
    }

    public static class ThreadPool {
        private Integer corePoolSize = this.calculateCoreNum();
        private Integer maxPoolSize = this.corePoolSize + (this.corePoolSize >> 1);
        private Long keepAliveTime = DefaultConfig.KEEPALIVETIME;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        private Long executeTimeOut = DefaultConfig.EXECUTETIMEOUT;
        private Integer capacity = DefaultConfig.THREADPOOLQUEUESIZE;
        private BlockingQueue workQueue = new LinkedBlockingQueue(this.capacity);
        private String rejectedExecutionHandler = "AbortPolicy";
        private String threadNamePrefix;
        private Boolean allowCoreThreadTimeOut = false;

        private Integer calculateCoreNum() {
            int cpuCoreNum = Runtime.getRuntime().availableProcessors();
            return new BigDecimal(cpuCoreNum).divide(new BigDecimal("0.2")).intValue();
        }

        public Integer getCorePoolSize() {
            return this.corePoolSize;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public Integer getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public Long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public void setKeepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        public Long getExecuteTimeOut() {
            return this.executeTimeOut;
        }

        public void setExecuteTimeOut(long executeTimeOut) {
            this.executeTimeOut = executeTimeOut;
        }

        public Integer getCapacity() {
            return this.capacity;
        }

        public void setCapacity(int capacity) {
            this.capacity = capacity;
        }

        public BlockingQueue getWorkQueue() {
            return this.workQueue;
        }

        public void setWorkQueue(BlockingQueue workQueue) {
            this.workQueue = workQueue;
        }

        public String getThreadNamePrefix() {
            return this.threadNamePrefix;
        }

        public void setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
        }

        public Boolean getAllowCoreThreadTimeOut() {
            return this.allowCoreThreadTimeOut;
        }

        public void setAllowCoreThreadTimeOut(Boolean allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        }

        public String getRejectedExecutionHandler() {
            return this.rejectedExecutionHandler;
        }

        public void setRejectedExecutionHandler(String rejectedExecutionHandler) {
            this.rejectedExecutionHandler = rejectedExecutionHandler;
        }
    }
}

