/*
 * Decompiled with CFR 0.152.
 */
package com.gobrs.async.core.scan;

import com.gobrs.async.core.anno.Invoke;
import com.gobrs.async.core.anno.MethodComponent;
import com.gobrs.async.core.anno.MethodConfig;
import com.gobrs.async.core.anno.MethodTask;
import com.gobrs.async.core.cache.GCache;
import com.gobrs.async.core.cache.GCacheManager;
import com.gobrs.async.core.common.domain.GobrsTaskMethodEnum;
import com.gobrs.async.core.common.domain.MethodTaskMatch;
import com.gobrs.async.core.common.enums.TaskEnum;
import com.gobrs.async.core.common.exception.DuplicateMethodTaskException;
import com.gobrs.async.core.property.GobrsAsyncProperties;
import com.gobrs.async.core.scan.BaseScannner;
import com.gobrs.async.core.task.MethodTaskAdapter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class MethodComponentScanner
extends BaseScannner
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MethodComponentScanner.class);
    private GCacheManager gCacheManager;
    private GobrsAsyncProperties gobrsAsyncProperties;
    private final AtomicBoolean cousor = new AtomicBoolean(false);
    private ApplicationContext applicationContext;
    private static final List<String> filterMethods = Arrays.asList("equals", "hashCode", "toString", "annotationType");

    public MethodComponentScanner(GCacheManager gCacheManager, GobrsAsyncProperties gobrsAsyncProperties) {
        this.gCacheManager = gCacheManager;
        this.gobrsAsyncProperties = gobrsAsyncProperties;
    }

    @Override
    public void doScan() {
        Map values = this.applicationContext.getBeansWithAnnotation(MethodComponent.class);
        GCache methodTaskCache = this.gCacheManager.getGCache(TaskEnum.METHOD.getType());
        Map instance = (Map)methodTaskCache.instance();
        values.forEach((k, v) -> {
            Method[] methods = v.getClass().getMethods();
            Map<String, List<Method>> methodsWith = Arrays.stream(methods).collect(Collectors.groupingBy(Method::getName));
            for (Method targetMethod : methods) {
                MethodTask methodTask = (MethodTask)AnnotationUtils.getAnnotation((Method)targetMethod, MethodTask.class);
                if (!Objects.nonNull(methodTask)) continue;
                this.analysis((String)k, v, targetMethod, methodTask, instance, methodsWith);
            }
        });
    }

    private void analysis(String k, Object v, Method targetMethod, MethodTask methodTask, Map<String, MethodTaskAdapter> instance, Map<String, List<Method>> methodsWith) {
        MethodTaskAdapter methodTaskAdaptation = (MethodTaskAdapter)this.applicationContext.getBean(MethodTaskAdapter.class);
        methodTaskAdaptation.setName(methodTask.name());
        methodTaskAdaptation.setProxy(v);
        String customizeName = methodTask.name();
        if (StringUtils.isBlank((CharSequence)customizeName)) {
            customizeName = targetMethod.getName();
        }
        Invoke invoke = methodTask.invoke();
        MethodConfig config = methodTask.config();
        HashMap<String, MethodTaskMatch> PARAMETERS_CACHE = new HashMap<String, MethodTaskMatch>();
        this.extracted(invoke, PARAMETERS_CACHE, targetMethod, methodsWith);
        this.setter(methodTaskAdaptation, config, PARAMETERS_CACHE, customizeName);
        MethodTaskAdapter existed = instance.get(customizeName);
        if (Objects.nonNull(existed)) {
            throw new DuplicateMethodTaskException(customizeName);
        }
        instance.put(customizeName, methodTaskAdaptation);
    }

    private void setter(MethodTaskAdapter methodTaskAdaptation, MethodConfig config, Map<String, MethodTaskMatch> PARAMETERS_CACHE, String customizeName) {
        methodTaskAdaptation.setPARAMETERS_CACHE(PARAMETERS_CACHE);
        methodTaskAdaptation.setType(TaskEnum.METHOD.getType());
        methodTaskAdaptation.setRetryCount(config.retryCount());
        methodTaskAdaptation.setCallback(config.callback());
        methodTaskAdaptation.setTimeoutInMilliseconds(config.timeoutInMilliseconds());
        methodTaskAdaptation.setFailSubExec(config.failSubExec());
        methodTaskAdaptation.setExclusive(config.failSubExec());
        methodTaskAdaptation.setDesc(config.desc());
        methodTaskAdaptation.setName(customizeName);
    }

    private void extracted(Invoke invoke, Map<String, MethodTaskMatch> PARAMETERS_CACHE, Method targetMethod, Map<String, List<Method>> methodsWith) {
        Method[] annoMethods = invoke.getClass().getDeclaredMethods();
        List collectMethods = Arrays.stream(annoMethods).filter(x -> !filterMethods.contains(x.getName())).collect(Collectors.toList());
        for (Method annoMethod : collectMethods) {
            List<Method> methods;
            Object value = ReflectionUtils.invokeMethod((Method)annoMethod, (Object)invoke);
            if (GobrsTaskMethodEnum.TASK.getMethod().equals(annoMethod.getName())) {
                MethodTaskMatch match = MethodTaskMatch.builder().method(targetMethod).build();
                PARAMETERS_CACHE.put(annoMethod.getName(), match);
                continue;
            }
            if (value == null || !StringUtils.isNotBlank((CharSequence)value.toString()) || filterMethods.equals(annoMethod.getName()) || !(value instanceof String) || CollectionUtils.isEmpty(methods = methodsWith.get(value))) continue;
            Method m = methods.get(0);
            MethodTaskMatch match = MethodTaskMatch.builder().method(m).build();
            PARAMETERS_CACHE.put(annoMethod.getName(), match);
        }
    }

    public void init() {
        if (this.cousor.compareAndSet(false, true)) {
            this.doScan();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static class MethodTaskFactoryBean
    implements FactoryBean<MethodTaskAdapter> {
        public MethodTaskAdapter getObject() throws Exception {
            return new MethodTaskAdapter();
        }

        public Class<?> getObjectType() {
            return MethodTaskAdapter.class;
        }

        public boolean isSingleton() {
            return false;
        }
    }
}

