/*
 * Decompiled with CFR 0.152.
 */
package io.github.metarank.lightgbm4j;

import com.microsoft.ml.lightgbm.PredictionType;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_double;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_float;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_int;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_long_long;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_p_void;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_void;
import com.microsoft.ml.lightgbm.lightgbmlib;
import io.github.metarank.lightgbm4j.LGBMDataset;
import io.github.metarank.lightgbm4j.LGBMException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LGBMBooster
implements AutoCloseable {
    private int iterations;
    private SWIGTYPE_p_p_void handle;
    private static final long MODEL_SAVE_BUFFER_SIZE = 0xA00000L;
    private static final long EVAL_RESULTS_BUFFER_SIZE = 1024L;
    private static final Logger logger = LoggerFactory.getLogger(LGBMBooster.class);
    private static volatile boolean nativeLoaded = false;
    private volatile boolean isClosed = false;

    public static boolean isNativeLoaded() {
        return nativeLoaded;
    }

    public static synchronized void loadNative() throws IOException {
        block17: {
            if (!nativeLoaded) {
                String os = System.getProperty("os.name");
                String arch = System.getProperty("os.arch", "generic").toLowerCase(Locale.ENGLISH);
                if (os.startsWith("Linux") || os.startsWith("LINUX")) {
                    try {
                        if (arch.startsWith("amd64") || arch.startsWith("x86_64")) {
                            LGBMBooster.loadNative("lightgbm4j/linux/x86_64/", "lib_lightgbm.so");
                            LGBMBooster.loadNative("lightgbm4j/linux/x86_64/", "lib_lightgbm_swig.so");
                            nativeLoaded = true;
                        } else if (arch.startsWith("aarch64") || arch.startsWith("arm64")) {
                            LGBMBooster.loadNative("lightgbm4j/linux/aarch64/", "lib_lightgbm.so");
                            LGBMBooster.loadNative("lightgbm4j/linux/aarch64/", "lib_lightgbm_swig.so");
                            nativeLoaded = true;
                        }
                        break block17;
                    }
                    catch (UnsatisfiedLinkError err) {
                        String message = err.getMessage();
                        if (message.contains("libgomp")) {
                            logger.warn("\n\n\n");
                            logger.warn("****************************************************");
                            logger.warn("Your Linux system probably has no 'libgomp' library installed!");
                            logger.warn("Please double-check the lightgbm4j install instructions:");
                            logger.warn("- https://github.com/metarank/lightgbm4j/");
                            logger.warn("- or just install the libgomp with your package manager");
                            logger.warn("****************************************************");
                            logger.warn("\n\n\n");
                        }
                        break block17;
                    }
                }
                if (os.startsWith("Mac")) {
                    try {
                        if (arch.startsWith("amd64") || arch.startsWith("x86_64")) {
                            LGBMBooster.loadNative("lightgbm4j/osx/x86_64/", "lib_lightgbm.dylib");
                            LGBMBooster.loadNative("lightgbm4j/osx/x86_64/", "lib_lightgbm_swig.dylib");
                            nativeLoaded = true;
                        }
                        if (arch.startsWith("aarch64") || arch.startsWith("arm64")) {
                            LGBMBooster.loadNative("lightgbm4j/osx/aarch64/", "lib_lightgbm.dylib");
                            LGBMBooster.loadNative("lightgbm4j/osx/aarch64/", "lib_lightgbm_swig.dylib");
                            nativeLoaded = true;
                        }
                        logger.warn("arch " + arch + " is not supported");
                        throw new UnsatisfiedLinkError("no native lightgbm library found for your OS " + os);
                    }
                    catch (UnsatisfiedLinkError err) {
                        String message = err.getMessage();
                        if (message.contains("libomp.dylib")) {
                            logger.warn("\n\n\n");
                            logger.warn("****************************************************");
                            logger.warn("Your MacOS system probably has no 'libomp' library installed!");
                            logger.warn("Please double-check the lightgbm4j install instructions:");
                            logger.warn("- https://github.com/metarank/lightgbm4j/");
                            logger.warn("- or just do 'brew install libomp'");
                            logger.warn("****************************************************");
                            logger.warn("\n\n\n");
                        }
                        throw err;
                    }
                } else if (os.startsWith("Windows")) {
                    LGBMBooster.loadNative("lightgbm4j/windows/x86_64/", "lib_lightgbm.dll");
                    LGBMBooster.loadNative("lightgbm4j/windows/x86_64/", "lib_lightgbm_swig.dll");
                    nativeLoaded = true;
                } else {
                    logger.error("Only Linux@x86_64, Windows@x86_64, Mac@x86_64 and Mac@aarch are supported");
                }
            }
        }
    }

    private static void loadNative(String path, String name) throws IOException, UnsatisfiedLinkError {
        String nativePathOverride = System.getenv("LIGHTGBM_NATIVE_LIB_PATH");
        if (nativePathOverride != null) {
            if (!nativePathOverride.endsWith("/")) {
                nativePathOverride = nativePathOverride + "/";
            }
            String libFile = nativePathOverride + name;
            logger.info("LIGHTGBM_NATIVE_LIB_PATH is set: loading " + libFile);
            try {
                System.load(libFile);
            }
            catch (UnsatisfiedLinkError err) {
                logger.error("Cannot load library:" + err.getMessage(), (Throwable)err);
                throw err;
            }
        }
        logger.info("Loading native lib from resource " + path + "/" + name);
        String tmp = System.getProperty("java.io.tmpdir");
        File libFile = new File(tmp + File.separator + name);
        if (libFile.exists()) {
            logger.info(libFile + " already exists");
            LGBMBooster.extractResource(path + name, name, libFile);
        } else {
            LGBMBooster.extractResource(path + name, name, libFile);
        }
        logger.info("Extracted file: exists=" + libFile.exists() + " path=" + libFile);
        try {
            System.load(libFile.toString());
        }
        catch (UnsatisfiedLinkError err) {
            logger.error("Cannot load library:" + err.getMessage(), (Throwable)err);
            throw err;
        }
    }

    private static void extractResource(String path, String name, File dest) throws IOException {
        logger.info("Extracting native lib " + dest);
        InputStream libStream = LGBMBooster.class.getClassLoader().getResourceAsStream(path);
        ByteArrayOutputStream libByteStream = new ByteArrayOutputStream();
        LGBMBooster.copyStream(libStream, libByteStream);
        libStream.close();
        InputStream md5Stream = LGBMBooster.class.getClassLoader().getResourceAsStream(path + ".md5");
        ByteArrayOutputStream md5ByteStream = new ByteArrayOutputStream();
        LGBMBooster.copyStream(md5Stream, md5ByteStream);
        md5Stream.close();
        String expectedDigest = md5ByteStream.toString();
        try {
            byte[] digest = MessageDigest.getInstance("MD5").digest(libByteStream.toByteArray());
            String checksum = new BigInteger(1, digest).toString(16);
            for (int i = 0; i < 32 - checksum.length(); ++i) {
                checksum = "0" + checksum;
            }
            if (!checksum.equals(expectedDigest)) {
                logger.warn("\n\n\n");
                logger.warn("****************************************************");
                logger.warn("Hash mismatch between expected and real LightGBM native library in classpath!");
                logger.warn("Your JVM classpath has " + name + " with md5=" + checksum + " and we expect " + expectedDigest);
                logger.warn("This usually means that you have another LightGBM wrapper in classpath");
                logger.warn("- MMLSpark/SynapseML is the main suspect");
                logger.warn("****************************************************");
                logger.warn("\n\n\n");
            }
            ByteArrayInputStream source = new ByteArrayInputStream(libByteStream.toByteArray());
            FileOutputStream fileStream = new FileOutputStream(dest);
            LGBMBooster.copyStream(source, fileStream);
            source.close();
            ((OutputStream)fileStream).close();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("md5 algorithm not supported, cannot check digest");
        }
    }

    private static void copyStream(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        int bytesCopied = 0;
        while ((length = source.read(buf)) > 0) {
            target.write(buf, 0, length);
            bytesCopied += length;
        }
        logger.info("Copied " + bytesCopied + " bytes");
    }

    LGBMBooster(int iterations, SWIGTYPE_p_p_void handle) {
        this.iterations = iterations;
        this.handle = handle;
    }

    public static LGBMBooster createFromModelfile(String file) throws LGBMException {
        SWIGTYPE_p_p_void handle = lightgbmlib.new_voidpp();
        SWIGTYPE_p_int outIterations = lightgbmlib.new_intp();
        int result = lightgbmlib.LGBM_BoosterCreateFromModelfile(file, outIterations, handle);
        if (result < 0) {
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        int iterations = lightgbmlib.intp_value(outIterations);
        lightgbmlib.delete_intp(outIterations);
        return new LGBMBooster(iterations, handle);
    }

    public static LGBMBooster loadModelFromString(String model) throws LGBMException {
        SWIGTYPE_p_p_void handle = lightgbmlib.new_voidpp();
        SWIGTYPE_p_int outIterations = lightgbmlib.new_intp();
        int result = lightgbmlib.LGBM_BoosterLoadModelFromString(model, outIterations, handle);
        if (result < 0) {
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        int iterations = lightgbmlib.intp_value(outIterations);
        lightgbmlib.delete_intp(outIterations);
        return new LGBMBooster(iterations, handle);
    }

    @Override
    public void close() throws LGBMException {
        if (!this.isClosed) {
            this.isClosed = true;
            int result = lightgbmlib.LGBM_BoosterFree(lightgbmlib.voidpp_value(this.handle));
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
        } else {
            throw new LGBMException("Booster was already closed");
        }
    }

    public double[] predictForMat(float[] input, int rows, int cols, boolean isRowMajor, PredictionType predictionType, String parameter) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_float dataBuffer = lightgbmlib.new_floatArray(input.length);
            for (int i = 0; i < input.length; ++i) {
                lightgbmlib.floatArray_setitem(dataBuffer, i, input[i]);
            }
            SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
            long outSize = this.outBufferSize(rows, cols, predictionType);
            SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(outSize);
            int result = lightgbmlib.LGBM_BoosterPredictForMat(lightgbmlib.voidpp_value(this.handle), lightgbmlib.float_to_voidp_ptr(dataBuffer), lightgbmlib.C_API_DTYPE_FLOAT32, rows, cols, isRowMajor ? 1 : 0, predictionType.getType(), 0, this.iterations, parameter, outLength, outBuffer);
            if (result < 0) {
                lightgbmlib.delete_floatArray(dataBuffer);
                lightgbmlib.delete_int64_tp(outLength);
                lightgbmlib.delete_doubleArray(outBuffer);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            long length = lightgbmlib.int64_tp_value(outLength);
            double[] values = new double[(int)length];
            int i = 0;
            while ((long)i < length) {
                values[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
                ++i;
            }
            lightgbmlib.delete_floatArray(dataBuffer);
            lightgbmlib.delete_int64_tp(outLength);
            lightgbmlib.delete_doubleArray(outBuffer);
            return values;
        }
        throw new LGBMException("Booster was already closed");
    }

    public double[] predictForMat(float[] input, int rows, int cols, boolean isRowMajor, PredictionType predictionType) throws LGBMException {
        return this.predictForMat(input, rows, cols, isRowMajor, predictionType, "");
    }

    public double[] predictForMat(double[] input, int rows, int cols, boolean isRowMajor, PredictionType predictionType, String parameter) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_double dataBuffer = lightgbmlib.new_doubleArray(input.length);
            for (int i = 0; i < input.length; ++i) {
                lightgbmlib.doubleArray_setitem(dataBuffer, i, input[i]);
            }
            SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
            long outSize = this.outBufferSize(rows, cols, predictionType);
            SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(outSize);
            int result = lightgbmlib.LGBM_BoosterPredictForMat(lightgbmlib.voidpp_value(this.handle), lightgbmlib.double_to_voidp_ptr(dataBuffer), lightgbmlib.C_API_DTYPE_FLOAT64, rows, cols, isRowMajor ? 1 : 0, predictionType.getType(), 0, this.iterations, parameter, outLength, outBuffer);
            if (result < 0) {
                lightgbmlib.delete_doubleArray(dataBuffer);
                lightgbmlib.delete_int64_tp(outLength);
                lightgbmlib.delete_doubleArray(outBuffer);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            long length = lightgbmlib.int64_tp_value(outLength);
            double[] values = new double[(int)length];
            int i = 0;
            while ((long)i < length) {
                values[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
                ++i;
            }
            lightgbmlib.delete_doubleArray(dataBuffer);
            lightgbmlib.delete_int64_tp(outLength);
            lightgbmlib.delete_doubleArray(outBuffer);
            return values;
        }
        throw new LGBMException("Booster was already closed");
    }

    public double[] predictForMat(double[] input, int rows, int cols, boolean isRowMajor, PredictionType predictionType) throws LGBMException {
        return this.predictForMat(input, rows, cols, isRowMajor, predictionType, "");
    }

    public static LGBMBooster create(LGBMDataset dataset, String parameters) throws LGBMException {
        SWIGTYPE_p_p_void handle = lightgbmlib.new_voidpp();
        int result = lightgbmlib.LGBM_BoosterCreate(dataset.handle, parameters, handle);
        if (result < 0) {
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        return new LGBMBooster(0, handle);
    }

    public boolean updateOneIter() throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_int isFinishedP = lightgbmlib.new_intp();
            int result = lightgbmlib.LGBM_BoosterUpdateOneIter(lightgbmlib.voidpp_value(this.handle), isFinishedP);
            ++this.iterations;
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            int isFinished = lightgbmlib.intp_value(isFinishedP);
            lightgbmlib.delete_intp(isFinishedP);
            return isFinished == 1;
        }
        throw new LGBMException("Booster was already closed");
    }

    public String saveModelToString(int startIteration, int numIteration, FeatureImportanceType featureImportance) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
            String result = lightgbmlib.LGBM_BoosterSaveModelToStringSWIG(lightgbmlib.voidpp_value(this.handle), startIteration, numIteration, this.importanceType(featureImportance), 0xA00000L, outLength);
            lightgbmlib.delete_int64_tp(outLength);
            return result;
        }
        throw new LGBMException("Booster was already closed");
    }

    public String[] getFeatureNames() throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_void buffer = lightgbmlib.LGBM_BoosterGetFeatureNamesSWIG(lightgbmlib.voidpp_value(this.handle));
            String[] result = lightgbmlib.StringArrayHandle_get_strings(buffer);
            lightgbmlib.StringArrayHandle_free(buffer);
            return result;
        }
        throw new LGBMException("Booster was already closed");
    }

    public void addValidData(LGBMDataset dataset) throws LGBMException {
        if (!this.isClosed) {
            int result = lightgbmlib.LGBM_BoosterAddValidData(lightgbmlib.voidpp_value(this.handle), dataset.handle);
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
        } else {
            throw new LGBMException("Booster was already closed");
        }
    }

    public double[] getEval(int dataIndex) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_int outLength = lightgbmlib.new_int32_tp();
            SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(1024L);
            int result = lightgbmlib.LGBM_BoosterGetEval(lightgbmlib.voidpp_value(this.handle), dataIndex, outLength, outBuffer);
            if (result < 0) {
                lightgbmlib.delete_intp(outLength);
                lightgbmlib.delete_doubleArray(outBuffer);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            double[] evals = new double[lightgbmlib.intp_value(outLength)];
            for (int i = 0; i < evals.length; ++i) {
                evals[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
            }
            lightgbmlib.delete_intp(outLength);
            lightgbmlib.delete_doubleArray(outBuffer);
            return evals;
        }
        throw new LGBMException("Booster was already closed");
    }

    public String[] getEvalNames() throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_void namesP = lightgbmlib.LGBM_BoosterGetEvalNamesSWIG(lightgbmlib.voidpp_value(this.handle));
            String[] names = lightgbmlib.StringArrayHandle_get_strings(namesP);
            lightgbmlib.StringArrayHandle_free(namesP);
            return names;
        }
        throw new LGBMException("Booster was already closed");
    }

    public double[] featureImportance(int numIteration, FeatureImportanceType importanceType) throws LGBMException {
        if (!this.isClosed) {
            int numFeatures = this.getNumFeature();
            SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(numFeatures);
            int result = lightgbmlib.LGBM_BoosterFeatureImportance(lightgbmlib.voidpp_value(this.handle), numIteration, this.importanceType(importanceType), outBuffer);
            if (result < 0) {
                lightgbmlib.delete_doubleArray(outBuffer);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            double[] importance = new double[numFeatures];
            for (int i = 0; i < numFeatures; ++i) {
                importance[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
            }
            lightgbmlib.delete_doubleArray(outBuffer);
            return importance;
        }
        throw new LGBMException("Booster was already closed");
    }

    public int getNumFeature() throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_int outNum = lightgbmlib.new_int32_tp();
            int result = lightgbmlib.LGBM_BoosterGetNumFeature(lightgbmlib.voidpp_value(this.handle), outNum);
            if (result < 0) {
                lightgbmlib.delete_intp(outNum);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            int num = lightgbmlib.intp_value(outNum);
            lightgbmlib.delete_intp(outNum);
            return num;
        }
        throw new LGBMException("Booster was already closed");
    }

    public double predictForMatSingleRow(double[] data, PredictionType predictionType) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_double dataBuffer = lightgbmlib.new_doubleArray(data.length);
            for (int i = 0; i < data.length; ++i) {
                lightgbmlib.doubleArray_setitem(dataBuffer, i, data[i]);
            }
            SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
            long outBufferSize = this.outBufferSize(1, data.length, predictionType);
            SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(outBufferSize);
            int result = lightgbmlib.LGBM_BoosterPredictForMatSingleRow(lightgbmlib.voidpp_value(this.handle), lightgbmlib.double_to_voidp_ptr(dataBuffer), lightgbmlib.C_API_DTYPE_FLOAT64, data.length, 1, predictionType.getType(), 0, this.iterations, "", outLength, outBuffer);
            if (result < 0) {
                lightgbmlib.delete_doubleArray(dataBuffer);
                lightgbmlib.delete_doubleArray(outBuffer);
                lightgbmlib.delete_int64_tp(outLength);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            long length = lightgbmlib.int64_tp_value(outLength);
            double[] values = new double[(int)length];
            int i = 0;
            while ((long)i < length) {
                values[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
                ++i;
            }
            lightgbmlib.delete_doubleArray(dataBuffer);
            lightgbmlib.delete_int64_tp(outLength);
            lightgbmlib.delete_doubleArray(outBuffer);
            return values[0];
        }
        throw new LGBMException("Booster was already closed");
    }

    public double predictForMatSingleRow(float[] data, PredictionType predictionType) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_float dataBuffer = lightgbmlib.new_floatArray(data.length);
            for (int i = 0; i < data.length; ++i) {
                lightgbmlib.floatArray_setitem(dataBuffer, i, data[i]);
            }
            SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
            long outBufferSize = this.outBufferSize(1, data.length, predictionType);
            SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(outBufferSize);
            int result = lightgbmlib.LGBM_BoosterPredictForMatSingleRow(lightgbmlib.voidpp_value(this.handle), lightgbmlib.float_to_voidp_ptr(dataBuffer), lightgbmlib.C_API_DTYPE_FLOAT32, data.length, 1, predictionType.getType(), 0, this.iterations, "", outLength, outBuffer);
            if (result < 0) {
                lightgbmlib.delete_floatArray(dataBuffer);
                lightgbmlib.delete_doubleArray(outBuffer);
                lightgbmlib.delete_int64_tp(outLength);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            long length = lightgbmlib.int64_tp_value(outLength);
            double[] values = new double[(int)length];
            int i = 0;
            while ((long)i < length) {
                values[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
                ++i;
            }
            lightgbmlib.delete_floatArray(dataBuffer);
            lightgbmlib.delete_int64_tp(outLength);
            lightgbmlib.delete_doubleArray(outBuffer);
            return values[0];
        }
        throw new LGBMException("Booster was already closed");
    }

    public FastConfig predictForMatSingleRowFastInit(PredictionType predictionType, int dtype, int ncols, String parameter) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_p_void out = lightgbmlib.voidpp_handle();
            int result = lightgbmlib.LGBM_BoosterPredictForMatSingleRowFastInit(lightgbmlib.voidpp_value(this.handle), predictionType.getType(), 0, this.iterations, dtype, ncols, parameter, out);
            if (result < 0) {
                lightgbmlib.delete_voidpp(out);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            return new FastConfig(out);
        }
        throw new LGBMException("Booster was already closed");
    }

    public double predictForMatSingleRowFast(FastConfig config, float[] data, PredictionType predictionType) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_float dataBuffer = lightgbmlib.new_floatArray(data.length);
            for (int i = 0; i < data.length; ++i) {
                lightgbmlib.floatArray_setitem(dataBuffer, i, data[i]);
            }
            SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
            long outBufferSize = this.outBufferSize(1, data.length, predictionType);
            SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(outBufferSize);
            int result = lightgbmlib.LGBM_BoosterPredictForMatSingleRowFast(lightgbmlib.voidpp_value(config.handle), lightgbmlib.float_to_voidp_ptr(dataBuffer), outLength, outBuffer);
            if (result < 0) {
                lightgbmlib.delete_floatArray(dataBuffer);
                lightgbmlib.delete_doubleArray(outBuffer);
                lightgbmlib.delete_int64_tp(outLength);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            long length = lightgbmlib.int64_tp_value(outLength);
            double[] values = new double[(int)length];
            int i = 0;
            while ((long)i < length) {
                values[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
                ++i;
            }
            lightgbmlib.delete_floatArray(dataBuffer);
            lightgbmlib.delete_int64_tp(outLength);
            lightgbmlib.delete_doubleArray(outBuffer);
            return values[0];
        }
        throw new LGBMException("Booster was already closed");
    }

    public double predictForMatSingleRowFast(FastConfig config, double[] data, PredictionType predictionType) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_double dataBuffer = lightgbmlib.new_doubleArray(data.length);
            for (int i = 0; i < data.length; ++i) {
                lightgbmlib.doubleArray_setitem(dataBuffer, i, data[i]);
            }
            SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
            long outBufferSize = this.outBufferSize(1, data.length, predictionType);
            SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(outBufferSize);
            int result = lightgbmlib.LGBM_BoosterPredictForMatSingleRowFast(lightgbmlib.voidpp_value(config.handle), lightgbmlib.double_to_voidp_ptr(dataBuffer), outLength, outBuffer);
            if (result < 0) {
                lightgbmlib.delete_doubleArray(dataBuffer);
                lightgbmlib.delete_doubleArray(outBuffer);
                lightgbmlib.delete_int64_tp(outLength);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            long length = lightgbmlib.int64_tp_value(outLength);
            double[] values = new double[(int)length];
            int i = 0;
            while ((long)i < length) {
                values[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
                ++i;
            }
            lightgbmlib.delete_doubleArray(dataBuffer);
            lightgbmlib.delete_int64_tp(outLength);
            lightgbmlib.delete_doubleArray(outBuffer);
            return values[0];
        }
        throw new LGBMException("Booster was already closed");
    }

    private int importanceType(FeatureImportanceType tpe) {
        int importanceType = lightgbmlib.C_API_FEATURE_IMPORTANCE_GAIN;
        switch (tpe.ordinal()) {
            case 1: {
                importanceType = lightgbmlib.C_API_FEATURE_IMPORTANCE_GAIN;
                break;
            }
            case 0: {
                importanceType = lightgbmlib.C_API_FEATURE_IMPORTANCE_SPLIT;
            }
        }
        return importanceType;
    }

    public int getNumClasses() throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_int numHandle = lightgbmlib.new_int32_tp();
            int result = lightgbmlib.LGBM_BoosterGetNumClasses(lightgbmlib.voidpp_value(this.handle), numHandle);
            if (result < 0) {
                lightgbmlib.delete_intp(numHandle);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            int numClasses = lightgbmlib.intp_value(numHandle);
            lightgbmlib.delete_intp(numHandle);
            return numClasses;
        }
        throw new LGBMException("Booster was already closed");
    }

    public long getNumPredict(int dataIdx) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_long_long numHandle = lightgbmlib.new_int64_tp();
            int result = lightgbmlib.LGBM_BoosterGetNumPredict(lightgbmlib.voidpp_value(this.handle), dataIdx, numHandle);
            if (result < 0) {
                lightgbmlib.delete_int64_tp(numHandle);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            long numClasses = lightgbmlib.int64_tp_value(numHandle);
            lightgbmlib.delete_int64_tp(numHandle);
            return numClasses;
        }
        throw new LGBMException("Booster was already closed");
    }

    public double[] getPredict(int dataIdx) throws LGBMException {
        if (!this.isClosed) {
            int allocatedSize = this.getNumClasses() * (int)this.getNumPredict(dataIdx);
            SWIGTYPE_p_double buffer = lightgbmlib.new_doubleArray(allocatedSize);
            SWIGTYPE_p_long_long size = lightgbmlib.new_int64_tp();
            int result = lightgbmlib.LGBM_BoosterGetPredict(lightgbmlib.voidpp_value(this.handle), dataIdx, size, buffer);
            if (result < 0) {
                lightgbmlib.delete_doubleArray(buffer);
                lightgbmlib.delete_int64_tp(size);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            double[] out = new double[(int)lightgbmlib.int64_tp_value(size)];
            for (int i = 0; i < out.length; ++i) {
                out[i] = lightgbmlib.doubleArray_getitem(buffer, i);
            }
            lightgbmlib.delete_doubleArray(buffer);
            lightgbmlib.delete_int64_tp(size);
            return out;
        }
        throw new LGBMException("Booster was already closed");
    }

    public boolean updateOneIterCustom(float[] grad, float[] hess) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_float gradHandle = lightgbmlib.new_floatArray(grad.length);
            for (int i = 0; i < grad.length; ++i) {
                lightgbmlib.floatArray_setitem(gradHandle, i, grad[i]);
            }
            SWIGTYPE_p_float hessHandle = lightgbmlib.new_floatArray(hess.length);
            for (int i = 0; i < hess.length; ++i) {
                lightgbmlib.floatArray_setitem(hessHandle, i, hess[i]);
            }
            SWIGTYPE_p_int isFinishedHandle = lightgbmlib.new_intp();
            int result = lightgbmlib.LGBM_BoosterUpdateOneIterCustom(lightgbmlib.voidpp_value(this.handle), gradHandle, hessHandle, isFinishedHandle);
            if (result < 0) {
                lightgbmlib.delete_floatArray(gradHandle);
                lightgbmlib.delete_floatArray(hessHandle);
                lightgbmlib.delete_intp(isFinishedHandle);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            int isFinished = lightgbmlib.intp_value(isFinishedHandle);
            lightgbmlib.delete_floatArray(gradHandle);
            lightgbmlib.delete_floatArray(hessHandle);
            lightgbmlib.delete_intp(isFinishedHandle);
            return isFinished == 1;
        }
        throw new LGBMException("Booster was already closed");
    }

    private long outBufferSize(int rows, int cols, PredictionType predictionType) {
        long defaultSize = 2L * (long)rows;
        if (PredictionType.C_API_PREDICT_CONTRIB.equals(predictionType)) {
            return defaultSize * (long)(cols + 1);
        }
        if (PredictionType.C_API_PREDICT_LEAF_INDEX.equals(predictionType)) {
            return defaultSize * (long)this.iterations;
        }
        return defaultSize;
    }

    static {
        try {
            LGBMBooster.loadNative();
        }
        catch (IOException e) {
            logger.info("Cannot load native library for your platform");
        }
    }

    public static enum FeatureImportanceType {
        SPLIT,
        GAIN;

    }

    public static class FastConfig
    implements AutoCloseable {
        public SWIGTYPE_p_p_void handle;

        public FastConfig(SWIGTYPE_p_p_void handle) {
            this.handle = handle;
        }

        @Override
        public void close() throws Exception {
            lightgbmlib.delete_voidpp(this.handle);
        }
    }
}

