/*
 * Decompiled with CFR 0.152.
 */
package io.github.metarank.lightgbm4j;

import com.microsoft.ml.lightgbm.SWIGTYPE_p_double;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_float;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_int;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_p_void;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_void;
import com.microsoft.ml.lightgbm.lightgbmlib;
import com.microsoft.ml.lightgbm.lightgbmlibJNI;
import io.github.metarank.lightgbm4j.LGBMBooster;
import io.github.metarank.lightgbm4j.LGBMException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LGBMDataset
implements AutoCloseable {
    private volatile boolean isClosed = false;
    private static final Logger logger = LoggerFactory.getLogger(LGBMDataset.class);
    public SWIGTYPE_p_void handle;

    LGBMDataset(SWIGTYPE_p_void handle) {
        this.handle = handle;
    }

    public static LGBMDataset createFromFile(String fileName, String parameters, LGBMDataset reference) throws LGBMException {
        SWIGTYPE_p_p_void handle;
        int result = lightgbmlib.LGBM_DatasetCreateFromFile(fileName, parameters, reference == null ? null : reference.handle, handle = lightgbmlib.new_voidpp());
        if (result < 0) {
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        return new LGBMDataset(lightgbmlib.voidpp_value(handle));
    }

    public static LGBMDataset createFromMat(float[] data, int rows, int cols, boolean isRowMajor, String parameters, LGBMDataset reference) throws LGBMException {
        SWIGTYPE_p_p_void handle = lightgbmlib.new_voidpp();
        SWIGTYPE_p_float dataBuffer = lightgbmlib.new_floatArray(data.length);
        for (int i = 0; i < data.length; ++i) {
            lightgbmlib.floatArray_setitem(dataBuffer, i, data[i]);
        }
        int result = lightgbmlib.LGBM_DatasetCreateFromMat(lightgbmlib.float_to_voidp_ptr(dataBuffer), lightgbmlib.C_API_DTYPE_FLOAT32, rows, cols, isRowMajor ? 1 : 0, parameters, reference == null ? null : reference.handle, handle);
        lightgbmlib.delete_floatArray(dataBuffer);
        if (result < 0) {
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        return new LGBMDataset(lightgbmlib.voidpp_value(handle));
    }

    public static LGBMDataset createFromMat(double[] data, int rows, int cols, boolean isRowMajor, String parameters, LGBMDataset reference) throws LGBMException {
        SWIGTYPE_p_p_void handle = lightgbmlib.new_voidpp();
        SWIGTYPE_p_double dataBuffer = lightgbmlib.new_doubleArray(data.length);
        for (int i = 0; i < data.length; ++i) {
            lightgbmlib.doubleArray_setitem(dataBuffer, i, data[i]);
        }
        int result = lightgbmlib.LGBM_DatasetCreateFromMat(lightgbmlib.double_to_voidp_ptr(dataBuffer), lightgbmlib.C_API_DTYPE_FLOAT64, rows, cols, isRowMajor ? 1 : 0, parameters, reference == null ? null : reference.handle, handle);
        lightgbmlib.delete_doubleArray(dataBuffer);
        if (result < 0) {
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        return new LGBMDataset(lightgbmlib.voidpp_value(handle));
    }

    public int getNumData() throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_int numDataP = lightgbmlib.new_intp();
            int result = lightgbmlib.LGBM_DatasetGetNumData(this.handle, numDataP);
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            int numData = lightgbmlib.intp_value(numDataP);
            lightgbmlib.delete_intp(numDataP);
            return numData;
        }
        throw new LGBMException("Dataset was already closed.");
    }

    public int getNumFeatures() throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_int numFeaturesP = lightgbmlib.new_intp();
            int result = lightgbmlib.LGBM_DatasetGetNumFeature(this.handle, numFeaturesP);
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            int numFeatures = lightgbmlib.intp_value(numFeaturesP);
            lightgbmlib.delete_intp(numFeaturesP);
            return numFeatures;
        }
        throw new LGBMException("Dataset was already closed.");
    }

    public void setFeatureNames(String[] featureNames) throws LGBMException {
        if (!this.isClosed) {
            int result = lightgbmlib.LGBM_DatasetSetFeatureNames(this.handle, featureNames, featureNames.length);
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
        } else {
            throw new LGBMException("Dataset was already closed.");
        }
    }

    public void dumpText(String fileName) throws LGBMException {
        if (!this.isClosed) {
            int result = lightgbmlib.LGBM_DatasetDumpText(this.handle, fileName);
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
        } else {
            throw new LGBMException("Dataset was already closed.");
        }
    }

    public void setField(String fieldName, double[] data) throws LGBMException {
        if (!this.isClosed) {
            if (fieldName.equals("label")) {
                throw new LGBMException("label can only be float[]");
            }
            if (fieldName.equals("weight")) {
                throw new LGBMException("weight can only be float[]");
            }
            SWIGTYPE_p_double dataBuffer = lightgbmlib.new_doubleArray(data.length);
            for (int i = 0; i < data.length; ++i) {
                lightgbmlib.doubleArray_setitem(dataBuffer, i, data[i]);
            }
            int result = lightgbmlib.LGBM_DatasetSetField(this.handle, fieldName, lightgbmlib.double_to_voidp_ptr(dataBuffer), data.length, lightgbmlib.C_API_DTYPE_FLOAT64);
            lightgbmlib.delete_doubleArray(dataBuffer);
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
        } else {
            throw new LGBMException("Dataset was already closed.");
        }
    }

    public void setField(String fieldName, int[] data) throws LGBMException {
        if (!this.isClosed) {
            if (fieldName.equals("label")) {
                throw new LGBMException("label can only be float[]");
            }
            if (fieldName.equals("weight")) {
                throw new LGBMException("weight can only be float[]");
            }
            SWIGTYPE_p_int dataBuffer = lightgbmlib.new_intArray(data.length);
            for (int i = 0; i < data.length; ++i) {
                lightgbmlib.intArray_setitem(dataBuffer, i, data[i]);
            }
            int result = lightgbmlib.LGBM_DatasetSetField(this.handle, fieldName, lightgbmlib.int_to_voidp_ptr(dataBuffer), data.length, lightgbmlib.C_API_DTYPE_INT32);
            lightgbmlib.delete_intArray(dataBuffer);
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
        } else {
            throw new LGBMException("Dataset was already closed.");
        }
    }

    public void setField(String fieldName, float[] data) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_float dataBuffer = lightgbmlib.new_floatArray(data.length);
            for (int i = 0; i < data.length; ++i) {
                lightgbmlib.floatArray_setitem(dataBuffer, i, data[i]);
            }
            int result = lightgbmlib.LGBM_DatasetSetField(this.handle, fieldName, lightgbmlib.float_to_voidp_ptr(dataBuffer), data.length, lightgbmlib.C_API_DTYPE_FLOAT32);
            lightgbmlib.delete_floatArray(dataBuffer);
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
        } else {
            throw new LGBMException("Dataset was already closed.");
        }
    }

    public String[] getFeatureNames() throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_void arrayHandle = lightgbmlib.LGBM_DatasetGetFeatureNamesSWIG(this.handle);
            String[] names = lightgbmlib.StringArrayHandle_get_strings(arrayHandle);
            lightgbmlib.StringArrayHandle_free(arrayHandle);
            return names;
        }
        throw new LGBMException("Dataset was already closed.");
    }

    public float[] getFieldFloat(String field) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_int typePtr;
            SWIGTYPE_p_p_void bufferPtr;
            SWIGTYPE_p_int lenPtr = lightgbmlib.new_intp();
            int result = lightgbmlib.LGBM_DatasetGetField(this.handle, field, lenPtr, bufferPtr = lightgbmlib.new_voidpp(), typePtr = lightgbmlib.new_intp());
            if (result < 0) {
                lightgbmlib.delete_intp(lenPtr);
                lightgbmlib.delete_voidpp(bufferPtr);
                lightgbmlib.delete_intp(typePtr);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            int len = lightgbmlib.intp_value(lenPtr);
            int type = lightgbmlib.intp_value(typePtr);
            if (type == lightgbmlib.C_API_DTYPE_FLOAT32) {
                SWIGTYPE_p_void buf = lightgbmlib.voidpp_value(bufferPtr);
                float[] out = new float[len];
                for (int i = 0; i < len; ++i) {
                    out[i] = lightgbmlibJNI.floatArray_getitem(SWIGTYPE_p_void.getCPtr(buf), i);
                }
                lightgbmlib.delete_intp(lenPtr);
                lightgbmlib.delete_voidpp(bufferPtr);
                lightgbmlib.delete_intp(typePtr);
                return out;
            }
            lightgbmlib.delete_intp(lenPtr);
            lightgbmlib.delete_voidpp(bufferPtr);
            lightgbmlib.delete_intp(typePtr);
            throw new LGBMException("getFieldFloat expects a float field (of ctype=" + lightgbmlib.C_API_DTYPE_FLOAT32 + ") but got ctype=" + type);
        }
        throw new LGBMException("Dataset was already closed.");
    }

    public int[] getFieldInt(String field) throws LGBMException {
        if (!this.isClosed) {
            SWIGTYPE_p_int typePtr;
            SWIGTYPE_p_p_void bufferPtr;
            SWIGTYPE_p_int lenPtr = lightgbmlib.new_intp();
            int result = lightgbmlib.LGBM_DatasetGetField(this.handle, field, lenPtr, bufferPtr = lightgbmlib.new_voidpp(), typePtr = lightgbmlib.new_intp());
            if (result < 0) {
                lightgbmlib.delete_intp(lenPtr);
                lightgbmlib.delete_voidpp(bufferPtr);
                lightgbmlib.delete_intp(typePtr);
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
            int len = lightgbmlib.intp_value(lenPtr);
            int type = lightgbmlib.intp_value(typePtr);
            if (type == lightgbmlib.C_API_DTYPE_INT32) {
                SWIGTYPE_p_void buf = lightgbmlib.voidpp_value(bufferPtr);
                int[] out = new int[len];
                for (int i = 0; i < len; ++i) {
                    out[i] = lightgbmlibJNI.intArray_getitem(SWIGTYPE_p_void.getCPtr(buf), i);
                }
                lightgbmlib.delete_intp(lenPtr);
                lightgbmlib.delete_voidpp(bufferPtr);
                lightgbmlib.delete_intp(typePtr);
                return out;
            }
            lightgbmlib.delete_intp(lenPtr);
            lightgbmlib.delete_voidpp(bufferPtr);
            lightgbmlib.delete_intp(typePtr);
            throw new LGBMException("getFieldFloat expects a float field (of ctype=" + lightgbmlib.C_API_DTYPE_FLOAT32 + ") but got ctype=" + type);
        }
        throw new LGBMException("Dataset was already closed.");
    }

    @Override
    public void close() throws LGBMException {
        if (!this.isClosed) {
            int result = lightgbmlib.LGBM_DatasetFree(this.handle);
            this.isClosed = true;
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
        }
    }

    static {
        try {
            LGBMBooster.loadNative();
        }
        catch (IOException e) {
            logger.error("Cannot load native library for your platform", (Throwable)e);
        }
    }
}

