/*
 * Decompiled with CFR 0.152.
 */
package io.github.metarank.ltrlib.booster;

import io.github.metarank.lightgbm4j.LGBMBooster;
import io.github.metarank.lightgbm4j.LGBMDataset;
import io.github.metarank.ltrlib.booster.Booster;
import io.github.metarank.ltrlib.booster.BoosterDataset;
import io.github.metarank.ltrlib.booster.LightGBMBooster;
import io.github.metarank.ltrlib.booster.LightGBMOptions;
import io.github.metarank.ltrlib.util.Logging;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class LightGBMBooster$
implements Booster.BoosterFactory<LGBMDataset, LightGBMBooster, LightGBMOptions>,
Logging,
Serializable {
    public static final LightGBMBooster$ MODULE$ = new LightGBMBooster$();
    private static Logger logger;

    static {
        Booster.BoosterFactory.$init$(MODULE$);
        Logging.$init$(MODULE$);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void io$github$metarank$ltrlib$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    @Override
    public LGBMDataset formatData(BoosterDataset d, Option<LGBMDataset> parent, LightGBMOptions options) {
        LGBMDataset ds;
        block0: {
            ds = LGBMDataset.createFromMat((double[])d.data(), (int)d.rows(), (int)d.cols(), (boolean)true, (String)"", (LGBMDataset)((LGBMDataset)parent.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            ds.setField("label", (float[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(d.labels()), (Function1)(JFunction1.mcFD.sp & Serializable)x$1 -> (float)x$1, (ClassTag)ClassTag$.MODULE$.Float()));
            ds.setField("group", d.groups());
            ds.setFeatureNames(d.featureNames());
            if (!options.debias()) break block0;
            ds.setField("position", d.positions());
        }
        return ds;
    }

    @Override
    public LightGBMBooster apply(byte[] string) {
        return new LightGBMBooster(LGBMBooster.loadModelFromString((String)new String(string, StandardCharsets.UTF_8)));
    }

    @Override
    public void closeData(LGBMDataset d) {
        d.close();
    }

    @Override
    public LightGBMBooster train(LGBMDataset dataset, Option<LGBMDataset> test, LightGBMOptions options, Booster.DatasetOptions dso) {
        Map paramsMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objective"), (Object)"lambdarank"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metric"), (Object)"ndcg"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lambdarank_truncation_level"), (Object)Integer.toString(options.ndcgCutoff())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_depth"), (Object)Integer.toString(options.maxDepth())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"learning_rate"), (Object)Double.toString(options.learningRate())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num_leaves"), (Object)Integer.toString(options.numLeaves())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seed"), (Object)Integer.toString(options.randomSeed())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"categorical_feature"), (Object)Predef$.MODULE$.wrapIntArray(dso.categoryFeatures()).mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_fraction"), (Object)Double.toString(options.featureFraction())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"eval_at"), (Object)Integer.toString(options.ndcgCutoff()))}));
        String params = ((IterableOnceOps)paramsMap.map((Function1 & Serializable)kv -> new StringBuilder(1).append(kv._1()).append("=").append(kv._2()).toString())).mkString(" ");
        LGBMBooster model = LGBMBooster.create((LGBMDataset)dataset, (String)params);
        test.foreach((Function1 & Serializable)t -> {
            model.addValidData(t);
            return BoxedUnit.UNIT;
        });
        int it = 0;
        boolean earlyStop = false;
        double lastBest = 0.0;
        int lastBestIter = 0;
        while (it < options.trees() && !earlyStop) {
            ++it;
            model.updateOneIter();
            double ndcgTrain = model.getEval(0)[0];
            Option<LGBMDataset> option = test;
            if (option instanceof Some) {
                double ndcgTest = model.getEval(1)[0];
                this.logger().info(new StringBuilder(29).append("[").append(it).append("] NDCG@train = ").append(ndcgTrain).append(" NDCG@test = ").append(ndcgTest).toString());
                Option<Object> option2 = options.earlyStopping();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    int esThreshold = BoxesRunTime.unboxToInt((Object)some.value());
                    if (ndcgTest > lastBest) {
                        lastBest = ndcgTest;
                        lastBestIter = it;
                    }
                    if (it - lastBestIter > esThreshold) {
                        this.logger().info(new StringBuilder(39).append("early stop: ").append(esThreshold).append(" rounds passed, best=").append(lastBest).append(" last=").append(ndcgTest).toString());
                        earlyStop = true;
                    }
                    continue;
                }
                if (None$.MODULE$.equals(option2)) {
                    continue;
                }
                throw new MatchError(option2);
            }
            if (None$.MODULE$.equals(option)) {
                this.logger().info(new StringBuilder(16).append("[").append(it).append("] NDCG@train = ").append(ndcgTrain).toString());
                continue;
            }
            throw new MatchError(option);
        }
        return new LightGBMBooster(model);
    }

    public LightGBMBooster apply(LGBMBooster model) {
        return new LightGBMBooster(model);
    }

    public Option<LGBMBooster> unapply(LightGBMBooster x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.model());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LightGBMBooster$.class);
    }

    private LightGBMBooster$() {
    }
}

