/*
 * Decompiled with CFR 0.152.
 */
package io.github.metarank.ltrlib.input;

import com.opencsv.CSVReader;
import io.github.metarank.ltrlib.input.CSVInputFormat;
import io.github.metarank.ltrlib.input.InputFormat;
import io.github.metarank.ltrlib.model.DatasetDescriptor;
import io.github.metarank.ltrlib.model.DatasetDescriptor$;
import io.github.metarank.ltrlib.model.Feature;
import io.github.metarank.ltrlib.model.LabeledItem;
import io.github.metarank.ltrlib.model.Query;
import io.github.metarank.ltrlib.model.Query$;
import io.github.metarank.ltrlib.util.Logging;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CSVInputFormat$
implements InputFormat {
    public static final CSVInputFormat$ MODULE$ = new CSVInputFormat$();
    private static Logger logger;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void io$github$metarank$ltrlib$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public Either<InputFormat.DatasetError, CSVInputFormat.CSVDataset> load(String groupColumn, String labelColumn, InputStream data) {
        CSVReader reader = new CSVReader((Reader)new InputStreamReader(data));
        String[] header = reader.readNext();
        Map headerMap = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])header))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        List featureNames = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])header), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CSVInputFormat$.$anonfun$load$1(groupColumn, x$1)))), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSVInputFormat$.$anonfun$load$2(labelColumn, x$2)))).toList();
        int cols = featureNames.length();
        DatasetDescriptor desc = DatasetDescriptor$.MODULE$.apply((List<Feature>)featureNames.map((Function1 & Serializable)name -> new Feature.SingularFeature((String)name)));
        this.logger().debug(new StringBuilder(23).append("opening CSV file: cols=").append(header.length).toString());
        return this.parseRows((Map<String, Object>)headerMap, groupColumn, labelColumn, reader, cols).map((Function1 & Serializable)rows -> {
            List queries = ((IterableOnceOps)rows.groupBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.group())).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    List rows = (List)tuple2._2();
                    return Query$.MODULE$.apply(desc, (List<LabeledItem>)rows);
                }
                throw new MatchError((Object)tuple2);
            })).toList();
            reader.close();
            MODULE$.logger().debug(new StringBuilder(30).append("loaded CSV file: rows=").append(rows.size()).append(" groups=").append(queries.size()).toString());
            return new CSVInputFormat.CSVDataset(desc, (List<Query>)queries);
        });
    }

    public Either<InputFormat.DatasetError, List<LabeledItem>> parseRows(Map<String, Object> header, String groupColumn, String labelColumn, CSVReader reader, int cols) {
        return header.get((Object)labelColumn).toRight((Function0 & Serializable)() -> new InputFormat.DatasetError(new StringBuilder(33).append("label column ").append(labelColumn).append(" not found in header").toString())).flatMap((Function1 & Serializable)labelCol -> CSVInputFormat$.$anonfun$parseRows$2(header, groupColumn, reader, cols, BoxesRunTime.unboxToInt((Object)labelCol)));
    }

    public Either<InputFormat.DatasetError, LabeledItem> parseRow(String[] row, int groupCol, int labelCol, int dim) {
        Left left;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(row[labelCol])));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            left = new Left((Object)new InputFormat.DatasetError(new StringBuilder(29).append("cannot parse label for row ").append(Predef$.MODULE$.wrapRefArray((Object[])row).toList()).append(": ").append(exception).toString()));
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            double value = BoxesRunTime.unboxToDouble((Object)success.value());
            left = new Right((Object)BoxesRunTime.boxToDouble((double)value));
        } else {
            throw new MatchError((Object)try_);
        }
        return left.flatMap((Function1 & Serializable)label -> CSVInputFormat$.$anonfun$parseRow$2(row, groupCol, dim, labelCol, BoxesRunTime.unboxToDouble((Object)label)));
    }

    public static final /* synthetic */ boolean $anonfun$load$1(String groupColumn$1, String x$1) {
        String string = x$1;
        String string2 = groupColumn$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$load$2(String labelColumn$1, String x$2) {
        String string = x$2;
        String string2 = labelColumn$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ Either $anonfun$parseRows$4(CSVReader reader$2, int labelCol$1, int cols$1, int groupCol) {
        Left left;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(reader$2.iterator()).asScala()).toList());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            left = new Left((Object)new InputFormat.DatasetError(new StringBuilder(15).append("error parsing: ").append(exception).toString()));
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            List value = (List)success.value();
            left = new Right((Object)value);
        } else {
            throw new MatchError((Object)try_);
        }
        return left.flatMap((Function1 & Serializable)rows -> {
            Right right;
            Tuple2 tuple2 = rows.map((Function1 & Serializable)row -> MODULE$.parseRow((String[])row, groupCol, labelCol$1, cols$1)).partition((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isLeft()));
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                List values = (List)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    right = new Right((Object)values.flatMap((Function1 & Serializable)x$5 -> x$5.toOption()));
                    return right.map((Function1 & Serializable)items -> items);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            List list = (List)tuple2._1();
            if (!(list instanceof .colon.colon)) throw new MatchError((Object)tuple2);
            .colon.colon colon2 = (.colon.colon)list;
            Either either = (Either)colon2.head();
            if (!(either instanceof Left)) throw new MatchError((Object)tuple2);
            Left left = (Left)either;
            InputFormat.DatasetError err = (InputFormat.DatasetError)left.value();
            right = new Left((Object)err);
            return right.map((Function1 & Serializable)items -> items);
        });
    }

    public static final /* synthetic */ Either $anonfun$parseRows$2(Map header$1, String groupColumn$2, CSVReader reader$2, int cols$1, int labelCol) {
        return header$1.get((Object)groupColumn$2).toRight((Function0 & Serializable)() -> new InputFormat.DatasetError(new StringBuilder(33).append("group column ").append(groupColumn$2).append(" not found in header").toString())).flatMap((Function1 & Serializable)groupCol -> CSVInputFormat$.$anonfun$parseRows$4(reader$2, labelCol, cols$1, BoxesRunTime.unboxToInt((Object)groupCol)));
    }

    public static final /* synthetic */ LabeledItem $anonfun$parseRow$4(int dim$1, String[] row$1, int labelCol$2, int groupCol$2, double label$1, int group) {
        double[] values = new double[dim$1];
        int j = 0;
        for (int i = 0; i < row$1.length; ++i) {
            if (i == labelCol$2 || i == groupCol$2) continue;
            values[j] = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(row$1[i]));
            ++j;
        }
        return new LabeledItem(label$1, group, values);
    }

    public static final /* synthetic */ Either $anonfun$parseRow$2(String[] row$1, int groupCol$2, int dim$1, int labelCol$2, double label) {
        Left left;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(row$1[groupCol$2])));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            left = new Left((Object)new InputFormat.DatasetError(new StringBuilder(29).append("cannot parse group for row ").append(Predef$.MODULE$.wrapRefArray((Object[])row$1).toList()).append(": ").append(exception).toString()));
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            int value = BoxesRunTime.unboxToInt((Object)success.value());
            left = new Right((Object)BoxesRunTime.boxToInteger((int)value));
        } else {
            throw new MatchError((Object)try_);
        }
        return left.map((Function1 & Serializable)group -> CSVInputFormat$.$anonfun$parseRow$4(dim$1, row$1, labelCol$2, groupCol$2, label, BoxesRunTime.unboxToInt((Object)group)));
    }

    private CSVInputFormat$() {
    }
}

