/*
 * Decompiled with CFR 0.152.
 */
package io.github.metarank.ltrlib.input;

import io.github.metarank.ltrlib.input.InputFormat;
import io.github.metarank.ltrlib.model.DatasetDescriptor;
import io.github.metarank.ltrlib.model.LabeledItem;
import io.github.metarank.ltrlib.model.Query;
import io.github.metarank.ltrlib.model.Query$;
import io.github.metarank.ltrlib.util.Logging;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class LibsvmInputFormat$
implements InputFormat {
    public static final LibsvmInputFormat$ MODULE$ = new LibsvmInputFormat$();
    private static final Regex queryPattern;
    private static Logger logger;

    static {
        Logging.$init$(MODULE$);
        queryPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(qid:)?([0-9]+)"));
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void io$github$metarank$ltrlib$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public List<Query> load(InputStream data, DatasetDescriptor desc) {
        BoxedUnit boxedUnit;
        long firstTick;
        BufferedReader lines = new BufferedReader(new InputStreamReader(data));
        ArrayBuffer groups = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int lastGroup = Integer.MIN_VALUE;
        ArrayBuffer groupBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        long lastTick = firstTick = System.currentTimeMillis();
        int rowsRead = 0;
        int rowsReadPerTick = 0;
        long memUsed = 0L;
        while (lines.ready()) {
            Buffer buffer;
            String line = lines.readLine();
            LabeledItem labeled = this.parseLine(desc.dim(), line, this.parseLine$default$3());
            if (labeled.group() == lastGroup) {
                buffer = groupBuffer.append((Object)labeled);
            } else {
                if (groupBuffer.nonEmpty()) {
                    Query group = Query$.MODULE$.apply(desc, (List<LabeledItem>)groupBuffer.toList());
                    groups.append((Object)group);
                    memUsed += (long)group.memUsed();
                    groupBuffer.clear();
                }
                groupBuffer.append((Object)labeled);
                lastGroup = labeled.group();
                buffer = BoxedUnit.UNIT;
            }
            ++rowsRead;
            ++rowsReadPerTick;
            long now = System.currentTimeMillis();
            if (now - lastTick <= 1000L) continue;
            this.logger().debug(new StringBuilder(32).append("loaded ").append(rowsRead).append(" rows, ").append(groups.length()).append(" groups, ").append(1000.0 * (double)rowsReadPerTick / (double)(now - lastTick)).append(" rows/sec").toString());
            lastTick = now;
            rowsReadPerTick = 0;
        }
        if (groupBuffer.nonEmpty()) {
            Query group = Query$.MODULE$.apply(desc, (List<LabeledItem>)groupBuffer.toList());
            boxedUnit = groups.append((Object)group);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.logger().debug(new StringBuilder(54).append("finished loading dataset: ").append(rowsRead).append(" rows ").append(groups.length()).append(", took ").append(System.currentTimeMillis() - firstTick).append("ms, ").append(memUsed).append(" bytes used").toString());
        return groups.toList();
    }

    public Regex queryPattern() {
        return queryPattern;
    }

    public LabeledItem parseLine(int dim, String line, int index) {
        Option option;
        String[] tokens = (String[])ArrayOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(line), ' ')), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LibsvmInputFormat$.$anonfun$parseLine$1(x$1)));
        if (tokens.length < 3) {
            throw new IllegalArgumentException(new StringBuilder(76).append("LibSVM format requires at least two columns: label and qid, but got ").append(tokens.length).append(" on row ").append(index).toString());
        }
        double label = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(tokens[0]));
        String string = tokens[1];
        if (string == null || (option = this.queryPattern().unapplySeq((CharSequence)string)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(2) != 0) {
            throw new IllegalArgumentException(new StringBuilder(47).append("qid format for item '").append(tokens[1]).append("' is not supported on row ").append(index).toString());
        }
        String id = (String)((LinearSeqOps)option.get()).apply(1);
        int qid = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(id));
        double[] values = new double[dim];
        for (int i = 2; i < tokens.length; ++i) {
            String[] featureValue = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(tokens[i]), ':');
            int featureIndex = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(featureValue[0]));
            double value = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(featureValue[1]));
            if (Double.isNaN(value) || Double.isInfinite(value)) {
                throw new IllegalArgumentException(new StringBuilder(56).append("error while parsing line '").append(line).append("': NaN value on index ").append(featureIndex).append(" on row ").append(index).toString());
            }
            if (featureIndex <= 0) {
                throw new IllegalArgumentException("feature index should be strictly greater than zero");
            }
            if (featureIndex > dim) {
                throw new IllegalArgumentException(new StringBuilder(54).append("feature index is out of range: index=").append(featureIndex).append(" max_index=").append(dim).append(", row=").append(index).toString());
            }
            values[featureIndex - 1] = value;
        }
        return new LabeledItem(label, qid, values);
    }

    public int parseLine$default$3() {
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$parseLine$1(String x$1) {
        return !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(x$1), '#');
    }

    private LibsvmInputFormat$() {
    }
}

