/*
 * Decompiled with CFR 0.152.
 */
package io.github.metarank.ltrlib.output;

import com.opencsv.CSVWriter;
import io.github.metarank.ltrlib.model.Dataset;
import io.github.metarank.ltrlib.model.DatasetDescriptor;
import io.github.metarank.ltrlib.model.Feature;
import io.github.metarank.ltrlib.model.Query;
import io.github.metarank.ltrlib.output.OutputFormat;
import io.github.metarank.ltrlib.util.Logging;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class CSVOutputFormat$
implements OutputFormat {
    public static final CSVOutputFormat$ MODULE$ = new CSVOutputFormat$();
    private static Logger logger;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void io$github$metarank$ltrlib$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public void write(OutputStream stream, Dataset data, boolean header) {
        CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter(stream));
        if (header) {
            writer.writeNext((String[])this.writeHeader(data.desc()).toArray(ClassTag$.MODULE$.apply(String.class)), false);
        }
        data.groups().foreach((Function1 & Serializable)query -> {
            CSVOutputFormat$.$anonfun$write$1(writer, query);
            return BoxedUnit.UNIT;
        });
        writer.close();
        this.logger().debug(new StringBuilder(25).append("wrote ").append(data.groups().size()).append(" groups to CSV file").toString());
    }

    public List<List<String>> writeGroup(Query query) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), query.rows()).toList().map((Function1 & Serializable)rowIndex -> CSVOutputFormat$.$anonfun$writeGroup$1(query, BoxesRunTime.unboxToInt((Object)rowIndex)));
    }

    public List<String> writeHeader(DatasetDescriptor desc) {
        List header = (List)new .colon.colon((Object)"label", (List)new .colon.colon((Object)"group", (List)Nil$.MODULE$)).$plus$plus((IterableOnce)desc.features().flatMap((Function1 & Serializable)x0$1 -> {
            Feature feature = x0$1;
            if (feature instanceof Feature.SingularFeature) {
                Feature.SingularFeature singularFeature = (Feature.SingularFeature)feature;
                String name = singularFeature.name();
                return new .colon.colon((Object)name, (List)Nil$.MODULE$);
            }
            if (feature instanceof Feature.CategoryFeature) {
                Feature.CategoryFeature categoryFeature = (Feature.CategoryFeature)feature;
                String name = categoryFeature.name();
                return new .colon.colon((Object)name, (List)Nil$.MODULE$);
            }
            if (feature instanceof Feature.VectorFeature) {
                Feature.VectorFeature vectorFeature = (Feature.VectorFeature)feature;
                String name = vectorFeature.name();
                int size = vectorFeature.size();
                return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).map((Function1 & Serializable)i -> CSVOutputFormat$.$anonfun$writeHeader$2(name, BoxesRunTime.unboxToInt((Object)i)));
            }
            throw new MatchError((Object)feature);
        }));
        return header;
    }

    public String formatNumber(double d) {
        if (d % 1.0 == 0.0) {
            return String.valueOf(BoxesRunTime.boxToInteger((int)((int)d)));
        }
        return Double.toString(d);
    }

    public static final /* synthetic */ void $anonfun$write$1(CSVWriter writer$1, Query query) {
        MODULE$.writeGroup(query).foreach((Function1 & Serializable)line -> {
            writer$1.writeNext((String[])line.toArray(ClassTag$.MODULE$.apply(String.class)), false);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ List $anonfun$writeGroup$1(Query query$1, int rowIndex) {
        double[] row = query$1.getRow(rowIndex);
        return (List)new .colon.colon((Object)Double.toString(query$1.labels()[rowIndex]), (List)new .colon.colon((Object)Integer.toString(query$1.group()), (List)Nil$.MODULE$)).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(row), (Function1 & Serializable)d -> CSVOutputFormat$.MODULE$.formatNumber(BoxesRunTime.unboxToDouble((Object)d)), ClassTag$.MODULE$.apply(String.class))));
    }

    public static final /* synthetic */ String $anonfun$writeHeader$2(String name$1, int i) {
        return new StringBuilder(1).append(name$1).append("_").append(i).toString();
    }

    private CSVOutputFormat$() {
    }
}

