/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.XGBoostJNI;

public class Communicator {
    public static Map<String, String> communicatorEnvs;
    public static List<String> mockList;

    private static void checkCall(int n) throws XGBoostError {
        if (n != 0) {
            throw new XGBoostError(XGBoostJNI.XGBGetLastError());
        }
    }

    public static void init(Map<String, String> map) throws XGBoostError {
        communicatorEnvs = map;
        String[] stringArray = new String[map.size() * 2 + mockList.size() * 2];
        int n = 0;
        for (Map.Entry<String, String> object : map.entrySet()) {
            stringArray[n++] = object.getKey();
            stringArray[n++] = object.getValue();
        }
        for (String string : mockList) {
            stringArray[n++] = "mock";
            stringArray[n++] = string;
        }
        Communicator.checkCall(XGBoostJNI.CommunicatorInit(stringArray));
    }

    public static void shutdown() throws XGBoostError {
        Communicator.checkCall(XGBoostJNI.CommunicatorFinalize());
    }

    public static void communicatorPrint(String string) throws XGBoostError {
        Communicator.checkCall(XGBoostJNI.CommunicatorPrint(string));
    }

    public static int getRank() throws XGBoostError {
        int[] nArray = new int[1];
        Communicator.checkCall(XGBoostJNI.CommunicatorGetRank(nArray));
        return nArray[0];
    }

    public static int getWorldSize() throws XGBoostError {
        int[] nArray = new int[1];
        Communicator.checkCall(XGBoostJNI.CommunicatorGetWorldSize(nArray));
        return nArray[0];
    }

    public static float[] allReduce(float[] fArray, OpType opType) {
        DataType dataType = DataType.FLOAT32;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(dataType.getSize() * fArray.length).order(ByteOrder.nativeOrder());
        for (float f : fArray) {
            byteBuffer.putFloat(f);
        }
        byteBuffer.flip();
        XGBoostJNI.CommunicatorAllreduce(byteBuffer, fArray.length, dataType.getEnumOp(), opType.getOperand());
        float[] fArray2 = new float[fArray.length];
        byteBuffer.asFloatBuffer().get(fArray2);
        return fArray2;
    }

    static {
        mockList = new LinkedList<String>();
    }

    public static enum DataType implements Serializable
    {
        INT8(0, 1),
        UINT8(1, 1),
        INT32(2, 4),
        UINT32(3, 4),
        INT64(4, 8),
        UINT64(5, 8),
        FLOAT32(6, 4),
        FLOAT64(7, 8);

        private final int enumOp;
        private final int size;

        public int getEnumOp() {
            return this.enumOp;
        }

        public int getSize() {
            return this.size;
        }

        private DataType(int n2, int n3) {
            this.enumOp = n2;
            this.size = n3;
        }
    }

    public static enum OpType implements Serializable
    {
        MAX(0),
        MIN(1),
        SUM(2);

        private int op;

        public int getOperand() {
            return this.op;
        }

        private OpType(int n2) {
            this.op = n2;
        }
    }
}

