/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import ml.dmlc.xgboost4j.java.Column;
import ml.dmlc.xgboost4j.java.ColumnBatch;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.XGBoostJNI;
import ml.dmlc.xgboost4j.java.util.BigDenseMatrix;

public class DMatrix {
    protected long handle = 0L;

    public DMatrix(String string) throws XGBoostError {
        if (string == null) {
            throw new NullPointerException("dataPath: null");
        }
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromFile(string, 1, lArray));
        this.handle = lArray[0];
    }

    @Deprecated
    public DMatrix(long[] lArray, int[] nArray, float[] fArray, SparseType sparseType) throws XGBoostError {
        this(lArray, nArray, fArray, sparseType, 0, Float.NaN, -1);
    }

    public DMatrix(long[] lArray, int[] nArray, float[] fArray, SparseType sparseType, int n) throws XGBoostError {
        this(lArray, nArray, fArray, sparseType, n, Float.NaN, -1);
    }

    public DMatrix(long[] lArray, int[] nArray, float[] fArray, SparseType sparseType, int n, float f, int n2) throws XGBoostError {
        long[] lArray2 = new long[1];
        if (sparseType == SparseType.CSR) {
            XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromCSR(lArray, nArray, fArray, n, f, n2, lArray2));
        } else if (sparseType == SparseType.CSC) {
            XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromCSC(lArray, nArray, fArray, n, f, n2, lArray2));
        } else {
            throw new UnknownError("unknow sparsetype");
        }
        this.handle = lArray2[0];
    }

    @Deprecated
    public DMatrix(float[] fArray, int n, int n2) throws XGBoostError {
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromMat(fArray, n, n2, 0.0f, lArray));
        this.handle = lArray[0];
    }

    public DMatrix(BigDenseMatrix bigDenseMatrix) throws XGBoostError {
        this(bigDenseMatrix, 0.0f);
    }

    public DMatrix(float[] fArray, int n, int n2, float f) throws XGBoostError {
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromMat(fArray, n, n2, f, lArray));
        this.handle = lArray[0];
    }

    public DMatrix(BigDenseMatrix bigDenseMatrix, float f) throws XGBoostError {
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromMatRef(bigDenseMatrix.address, bigDenseMatrix.nrow, bigDenseMatrix.ncol, f, lArray));
        this.handle = lArray[0];
    }

    protected DMatrix(long l) {
        this.handle = l;
    }

    public DMatrix(ColumnBatch columnBatch, float f, int n) throws XGBoostError {
        long[] lArray = new long[1];
        String string = columnBatch.getFeatureArrayInterface();
        if (string == null || string.isEmpty()) {
            throw new XGBoostError("Expecting non-empty feature columns' array interface");
        }
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromArrayInterfaceColumns(string, f, n, lArray));
        this.handle = lArray[0];
    }

    public void setLabel(Column column) throws XGBoostError {
        this.setXGBDMatrixInfo("label", column.getArrayInterfaceJson());
    }

    public void setWeight(Column column) throws XGBoostError {
        this.setXGBDMatrixInfo("weight", column.getArrayInterfaceJson());
    }

    public void setBaseMargin(Column column) throws XGBoostError {
        this.setXGBDMatrixInfo("base_margin", column.getArrayInterfaceJson());
    }

    private void setXGBDMatrixInfo(String string, String string2) throws XGBoostError {
        if (string2 == null || string2.isEmpty()) {
            throw new XGBoostError("Empty " + string + " columns' array interface");
        }
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSetInfoFromInterface(this.handle, string, string2));
    }

    private void setXGBDMatrixFeatureInfo(String string, String[] stringArray) throws XGBoostError {
        if (string == null || string.isEmpty()) {
            throw new XGBoostError("Found empty type");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new XGBoostError("Found empty values");
        }
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSetStrFeatureInfo(this.handle, string, stringArray));
    }

    private String[] getXGBDMatrixFeatureInfo(String string) throws XGBoostError {
        if (string == null || string.isEmpty()) {
            throw new XGBoostError("Found empty type");
        }
        long[] lArray = new long[1];
        String[][] stringArray = new String[1][];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixGetStrFeatureInfo(this.handle, string, lArray, stringArray));
        if (lArray[0] != (long)stringArray[0].length) {
            throw new RuntimeException("Failed to get " + string);
        }
        return stringArray[0];
    }

    public void setFeatureNames(String[] stringArray) throws XGBoostError {
        this.setXGBDMatrixFeatureInfo("feature_name", stringArray);
    }

    public String[] getFeatureNames() throws XGBoostError {
        return this.getXGBDMatrixFeatureInfo("feature_name");
    }

    public void setFeatureTypes(String[] stringArray) throws XGBoostError {
        this.setXGBDMatrixFeatureInfo("feature_type", stringArray);
    }

    public String[] getFeatureTypes() throws XGBoostError {
        return this.getXGBDMatrixFeatureInfo("feature_type");
    }

    public void setLabel(float[] fArray) throws XGBoostError {
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSetFloatInfo(this.handle, "label", fArray));
    }

    public void setWeight(float[] fArray) throws XGBoostError {
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSetFloatInfo(this.handle, "weight", fArray));
    }

    public void setBaseMargin(float[] fArray) throws XGBoostError {
        if ((long)fArray.length != this.rowNum()) {
            throw new IllegalArgumentException(String.format("base margin must have exactly %s elements, got %s", this.rowNum(), fArray.length));
        }
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSetFloatInfo(this.handle, "base_margin", fArray));
    }

    public void setBaseMargin(float[][] fArray) throws XGBoostError {
        this.setBaseMargin(DMatrix.flatten(fArray));
    }

    public void setGroup(int[] nArray) throws XGBoostError {
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSetUIntInfo(this.handle, "group", nArray));
    }

    public int[] getGroup() throws XGBoostError {
        return this.getIntInfo("group_ptr");
    }

    private float[] getFloatInfo(String string) throws XGBoostError {
        float[][] fArrayArray = new float[1][];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixGetFloatInfo(this.handle, string, fArrayArray));
        return fArrayArray[0];
    }

    private int[] getIntInfo(String string) throws XGBoostError {
        int[][] nArrayArray = new int[1][];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixGetUIntInfo(this.handle, string, nArrayArray));
        return nArrayArray[0];
    }

    public float[] getLabel() throws XGBoostError {
        return this.getFloatInfo("label");
    }

    public float[] getWeight() throws XGBoostError {
        return this.getFloatInfo("weight");
    }

    public float[] getBaseMargin() throws XGBoostError {
        return this.getFloatInfo("base_margin");
    }

    public DMatrix slice(int[] nArray) throws XGBoostError {
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSliceDMatrix(this.handle, nArray, lArray));
        long l = lArray[0];
        DMatrix dMatrix = new DMatrix(l);
        return dMatrix;
    }

    public long rowNum() throws XGBoostError {
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixNumRow(this.handle, lArray));
        return lArray[0];
    }

    public long nonMissingNum() throws XGBoostError {
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixNumNonMissing(this.handle, lArray));
        return lArray[0];
    }

    public void saveBinary(String string) {
        XGBoostJNI.XGDMatrixSaveBinary(this.handle, string, 1);
    }

    public long getHandle() {
        return this.handle;
    }

    private static float[] flatten(float[][] fArray) {
        int n = 0;
        for (float[] fArray2 : fArray) {
            n += fArray2.length;
        }
        float[] fArray3 = new float[n];
        int n2 = 0;
        for (float[] fArray4 : fArray) {
            System.arraycopy(fArray4, 0, fArray3, n2, fArray4.length);
            n2 += fArray4.length;
        }
        return fArray3;
    }

    protected void finalize() {
        this.dispose();
    }

    public synchronized void dispose() {
        if (this.handle != 0L) {
            XGBoostJNI.XGDMatrixFree(this.handle);
            this.handle = 0L;
        }
    }

    public static enum SparseType {
        CSR,
        CSC;

    }
}

