/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class NativeLibLoader {
    private static final Log logger = LogFactory.getLog(NativeLibLoader.class);
    private static boolean initialized = false;
    private static final String[] libNames = new String[]{"xgboost4j"};

    NativeLibLoader() {
    }

    static synchronized void initXGBoost() throws IOException {
        if (!initialized) {
            OS oS = OS.detectOS();
            Arch arch = Arch.detectArch();
            for (String string : libNames) {
                Object object;
                try {
                    String string2 = System.getenv("XGBOOST_NATIVE_LIB");
                    if (string2 != null) {
                        System.load(string2);
                        continue;
                    }
                    object = LibraryPathProvider.getLibraryPathFor(oS, arch, string);
                    NativeLibLoader.loadLibraryFromJar((String)object);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    object = "Failed to load " + string + " due to missing native dependencies for platform " + NativeLibLoader.getPlatformFor(oS, arch) + ", this is likely due to a missing OpenMP dependency";
                    switch (oS) {
                        case WINDOWS: {
                            logger.error(object);
                            logger.error((Object)"You may need to install 'vcomp140.dll' or 'libgomp-1.dll'");
                            break;
                        }
                        case MACOS: {
                            logger.error(object);
                            logger.error((Object)"You may need to install 'libomp.dylib', via `brew install libomp` or similar");
                            break;
                        }
                        case LINUX: {
                            logger.error(object);
                            logger.error((Object)"You may need to install 'libgomp.so' (or glibc) via your package manager.");
                            logger.error((Object)("Alternatively, if your Linux OS is musl-based, you should set the path for the native library " + string + " via the system property " + LibraryPathProvider.getPropertyNameForLibrary(string)));
                            break;
                        }
                        case SOLARIS: {
                            logger.error(object);
                            logger.error((Object)"You may need to install 'libgomp.so' (or glibc) via your package manager.");
                        }
                    }
                    throw unsatisfiedLinkError;
                }
                catch (IOException iOException) {
                    logger.error((Object)("Failed to load " + string + " library from jar for platform " + NativeLibLoader.getPlatformFor(oS, arch)));
                    throw iOException;
                }
            }
            initialized = true;
        }
    }

    private static void loadLibraryFromJar(String string) throws IOException, IllegalArgumentException {
        String string2 = NativeLibLoader.createTempFileFromResource(string);
        System.load(string2);
    }

    static String createTempFileFromResource(String string) throws IOException, IllegalArgumentException {
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] stringArray = string.split("/");
        String string2 = stringArray.length > 1 ? stringArray[stringArray.length - 1] : null;
        String string3 = "";
        String string4 = null;
        if (string2 != null) {
            stringArray = string2.split("\\.", 2);
            string3 = stringArray[0];
            String string5 = string4 = stringArray.length > 1 ? "." + stringArray[stringArray.length - 1] : null;
        }
        if (string2 == null || string3.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File file = File.createTempFile(string3, string4);
        file.deleteOnExit();
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " does not exist.");
        }
        byte[] byArray = new byte[1024];
        try (InputStream inputStream = NativeLibLoader.class.getResourceAsStream(string);
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            if (inputStream == null) {
                throw new FileNotFoundException("File " + string + " was not found inside JAR.");
            }
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        return file.getAbsolutePath();
    }

    private static String getPlatformFor(OS oS, Arch arch) {
        return oS.name + "/" + arch.name;
    }

    static class LibraryPathProvider {
        private static final String nativeResourcePath = "/lib";
        private static final String customNativeLibraryPathPropertyPrefix = "xgboostruntime.native.";

        LibraryPathProvider() {
        }

        static String getPropertyNameForLibrary(String string) {
            return customNativeLibraryPathPropertyPrefix + string;
        }

        static String getLibraryPathFor(OS oS, Arch arch, String string) {
            Object object = System.getProperty(LibraryPathProvider.getPropertyNameForLibrary(string));
            if (object == null) {
                object = "/lib/" + NativeLibLoader.getPlatformFor(oS, arch) + "/" + System.mapLibraryName(string);
            }
            logger.debug((Object)("Using path " + (String)object + " for library with name " + string));
            return object;
        }
    }

    static enum Arch {
        X86_64("x86_64"),
        AARCH64("aarch64"),
        SPARC("sparc");

        final String name;

        private Arch(String string2) {
            this.name = string2;
        }

        static Arch detectArch() {
            String string = System.getProperty("os.arch", "generic").toLowerCase(Locale.ENGLISH);
            if (string.startsWith("amd64") || string.startsWith("x86_64")) {
                return X86_64;
            }
            if (string.startsWith("aarch64") || string.startsWith("arm64")) {
                return AARCH64;
            }
            if (string.startsWith("sparc")) {
                return SPARC;
            }
            throw new IllegalStateException("Unsupported architecture:" + string);
        }
    }

    static enum OS {
        WINDOWS("windows"),
        MACOS("macos"),
        LINUX("linux"),
        SOLARIS("solaris");

        final String name;

        private OS(String string2) {
            this.name = string2;
        }

        static OS detectOS() {
            String string = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            if (string.contains("mac") || string.contains("darwin")) {
                return MACOS;
            }
            if (string.contains("win")) {
                return WINDOWS;
            }
            if (string.contains("nux")) {
                return LINUX;
            }
            if (string.contains("sunos")) {
                return SOLARIS;
            }
            throw new IllegalStateException("Unsupported OS:" + string);
        }
    }
}

