/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import ml.dmlc.xgboost4j.java.IRabitTracker;
import ml.dmlc.xgboost4j.java.NativeLibLoader;
import ml.dmlc.xgboost4j.java.TrackerProperties;
import ml.dmlc.xgboost4j.java.XGBoostError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RabitTracker
implements IRabitTracker {
    private static final Log logger = LogFactory.getLog(RabitTracker.class);
    private static String tracker_py = null;
    private static TrackerProperties trackerProperties = TrackerProperties.getInstance();
    private Map<String, String> envs = new HashMap<String, String>();
    private int numWorkers;
    private String hostIp = "";
    private String pythonExec = "";
    private AtomicReference<Process> trackerProcess = new AtomicReference();

    private static void initTrackerPy() throws IOException {
        try {
            tracker_py = NativeLibLoader.createTempFileFromResource("/tracker.py");
        }
        catch (IOException iOException) {
            logger.trace((Object)"cannot access tracker python script");
            throw iOException;
        }
    }

    public RabitTracker(int n) throws XGBoostError {
        if (n < 1) {
            throw new XGBoostError("numWorkers must be greater equal to one");
        }
        this.numWorkers = n;
    }

    public RabitTracker(int n, String string, String string2) throws XGBoostError {
        this(n);
        this.hostIp = string;
        this.pythonExec = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        logger.error((Object)"Uncaught exception thrown by worker:", throwable);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException);
        }
        finally {
            this.trackerProcess.get().destroy();
        }
    }

    @Override
    public Map<String, String> getWorkerEnvs() {
        return this.envs;
    }

    private void loadEnvs(InputStream inputStream) throws IOException {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            assert (bufferedReader.readLine().trim().equals("DMLC_TRACKER_ENV_START"));
            while ((string = bufferedReader.readLine()) != null && !string.trim().equals("DMLC_TRACKER_ENV_END")) {
                String[] stringArray = string.split("=");
                if (stringArray.length != 2) continue;
                this.envs.put(stringArray[0], stringArray[1]);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.error((Object)"cannot get runtime configuration from tracker process");
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public String getRabitTrackerCommand() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.pythonExec == null || this.pythonExec.isEmpty()) {
            stringBuilder.append("python ");
        } else {
            stringBuilder.append(this.pythonExec + " ");
        }
        stringBuilder.append(" " + tracker_py + " ");
        stringBuilder.append(" --log-level=DEBUG ");
        stringBuilder.append(" --num-workers=" + this.numWorkers + " ");
        String string = trackerProperties.getHostIp();
        if (string != null && !string.isEmpty()) {
            logger.debug((Object)("Using provided host-ip: " + string + " from properties"));
            stringBuilder.append(" --host-ip=" + string + " ");
        } else if (this.hostIp != null & !this.hostIp.isEmpty()) {
            logger.debug((Object)("Using the parametr host-ip: " + this.hostIp));
            stringBuilder.append(" --host-ip=" + this.hostIp + " ");
        }
        return stringBuilder.toString();
    }

    private boolean startTrackerProcess() {
        try {
            String string = this.getRabitTrackerCommand();
            this.trackerProcess.set(Runtime.getRuntime().exec(string));
            this.loadEnvs(this.trackerProcess.get().getInputStream());
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    @Override
    public void stop() {
        if (this.trackerProcess.get() != null) {
            this.trackerProcess.get().destroy();
        }
    }

    @Override
    public boolean start(long l) {
        if (l > 0L) {
            logger.warn((Object)"Python RabitTracker does not support timeout. The tracker will wait for all workers to connect indefinitely, unless it is interrupted manually. Use the Scala RabitTracker for timeout support.");
        }
        if (this.startTrackerProcess()) {
            logger.debug((Object)("Tracker started, with env=" + this.envs.toString()));
            System.out.println("Tracker started, with env=" + this.envs.toString());
            Thread thread = new Thread(new TrackerProcessLogger());
            thread.setDaemon(true);
            thread.start();
            return true;
        }
        logger.error((Object)"FAULT: failed to start tracker process");
        this.stop();
        return false;
    }

    @Override
    public int waitFor(long l) {
        if (l > 0L) {
            logger.warn((Object)"Python RabitTracker does not support timeout. The tracker will wait for either all workers to finish tasks and send shutdown signal, or manual interruptions. Use the Scala RabitTracker for timeout support.");
        }
        try {
            this.trackerProcess.get().waitFor();
            int n = this.trackerProcess.get().exitValue();
            logger.info((Object)("Tracker Process ends with exit code " + n));
            this.stop();
            return n;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            logger.error((Object)"the RabitTracker thread is terminated unexpectedly");
            return IRabitTracker.TrackerStatus.INTERRUPTED.getStatusCode();
        }
    }

    static {
        try {
            RabitTracker.initTrackerPy();
        }
        catch (IOException iOException) {
            logger.error((Object)"load tracker library failed.");
            logger.error((Object)iOException);
        }
    }

    private class TrackerProcessLogger
    implements Runnable {
        private TrackerProcessLogger() {
        }

        @Override
        public void run() {
            Log log = LogFactory.getLog(TrackerProcessLogger.class);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(RabitTracker.this.trackerProcess.get().getErrorStream()));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    log.info((Object)string);
                }
                RabitTracker.this.trackerProcess.get().waitFor();
                int n = RabitTracker.this.trackerProcess.get().exitValue();
                if (n != 0) {
                    log.error((Object)("Tracker Process ends with exit code " + n));
                } else {
                    log.info((Object)("Tracker Process ends with exit code " + n));
                }
            }
            catch (IOException iOException) {
                log.error((Object)iOException.toString());
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                logger.error((Object)"the RabitTracker thread is terminated unexpectedly");
            }
        }
    }
}

