/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java.util;

import ml.dmlc.xgboost4j.java.util.UtilUnsafe;

public final class BigDenseMatrix {
    private static final int FLOAT_BYTE_SIZE = 4;
    public static final long MAX_MATRIX_SIZE = 0x1FFFFFFFFFFFFFFFL;
    public final int nrow;
    public final int ncol;
    public final long address;

    public static void setDirect(long l, float f) {
        UtilUnsafe.UNSAFE.putFloat(l, f);
    }

    public static float getDirect(long l) {
        return UtilUnsafe.UNSAFE.getFloat(l);
    }

    public BigDenseMatrix(int n, int n2) {
        long l = (long)n * (long)n2;
        if (l > 0x1FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Matrix too large; matrix size cannot exceed 2305843009213693951");
        }
        this.nrow = n;
        this.ncol = n2;
        this.address = UtilUnsafe.UNSAFE.allocateMemory(l * 4L);
    }

    public final void set(long l, float f) {
        BigDenseMatrix.setDirect(this.address + l * 4L, f);
    }

    public final void set(int n, int n2, float f) {
        this.set(this.index(n, n2), f);
    }

    public final float get(long l) {
        return BigDenseMatrix.getDirect(this.address + l * 4L);
    }

    public final float get(int n, int n2) {
        return this.get(this.index(n, n2));
    }

    public final void dispose() {
        UtilUnsafe.UNSAFE.freeMemory(this.address);
    }

    private long index(int n, int n2) {
        return (long)n * (long)this.ncol + (long)n2;
    }
}

