/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.generator;

import io.github.mfvanek.pg.generator.DbMigrationGenerator;
import io.github.mfvanek.pg.model.table.TableNameAware;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

abstract class AbstractDbMigrationGenerator<T extends TableNameAware>
implements DbMigrationGenerator<T> {
    protected static final String DELIMITER = "_";

    AbstractDbMigrationGenerator() {
    }

    @Override
    @Nonnull
    public final List<String> generate(@Nonnull List<T> rows) {
        Objects.requireNonNull(rows, "rows cannot be null");
        ArrayList<String> migrations = new ArrayList<String>(rows.size());
        for (TableNameAware row : rows) {
            migrations.add(this.generate(row));
        }
        return migrations;
    }

    @Nonnull
    protected abstract String generate(@Nonnull T var1);
}

