/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.generator;

import io.github.mfvanek.pg.generator.IdxPosition;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GeneratingOptions {
    private final boolean concurrently;
    private final boolean excludeNulls;
    private final boolean breakLines;
    private final int indentation;
    private final boolean uppercaseForKeywords;
    private final boolean nameWithoutNulls;
    private final IdxPosition idxPosition;

    private GeneratingOptions(boolean concurrently, boolean excludeNulls, boolean breakLines, int indentation, boolean uppercaseForKeywords, boolean nameWithoutNulls, @Nonnull IdxPosition idxPosition) {
        this.concurrently = concurrently;
        this.excludeNulls = excludeNulls;
        this.breakLines = breakLines;
        this.indentation = indentation;
        this.uppercaseForKeywords = uppercaseForKeywords;
        this.nameWithoutNulls = nameWithoutNulls;
        this.idxPosition = idxPosition;
    }

    public boolean isConcurrently() {
        return this.concurrently;
    }

    public boolean isExcludeNulls() {
        return this.excludeNulls;
    }

    public boolean isBreakLines() {
        return this.breakLines;
    }

    public int getIndentation() {
        return this.indentation;
    }

    public boolean isUppercaseForKeywords() {
        return this.uppercaseForKeywords;
    }

    public boolean isNameWithoutNulls() {
        return this.nameWithoutNulls;
    }

    @Nonnull
    public IdxPosition getIdxPosition() {
        return this.idxPosition;
    }

    public boolean isNeedToAddIdx() {
        return this.idxPosition != IdxPosition.NONE;
    }

    @Nonnull
    public String toString() {
        return GeneratingOptions.class.getSimpleName() + "{concurrently=" + this.concurrently + ", excludeNulls=" + this.excludeNulls + ", breakLines=" + this.breakLines + ", indentation=" + this.indentation + ", uppercaseForKeywords=" + this.uppercaseForKeywords + ", nameWithoutNulls=" + this.nameWithoutNulls + ", idxPosition=" + this.idxPosition + "}";
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean concurrently = true;
        private boolean excludeNulls = true;
        private boolean breakLines = true;
        private int indentation = 4;
        private boolean uppercaseForKeywords;
        private boolean nameWithoutNulls = true;
        private IdxPosition idxPosition = IdxPosition.SUFFIX;

        private Builder() {
        }

        @Nonnull
        public GeneratingOptions build() {
            return new GeneratingOptions(this.concurrently, this.excludeNulls, this.breakLines, this.indentation, this.uppercaseForKeywords, this.nameWithoutNulls, this.idxPosition);
        }

        @Nonnull
        public Builder concurrently() {
            this.concurrently = true;
            return this;
        }

        @Nonnull
        public Builder normally() {
            this.concurrently = false;
            return this;
        }

        @Nonnull
        public Builder excludeNulls() {
            this.excludeNulls = true;
            return this;
        }

        @Nonnull
        public Builder includeNulls() {
            this.excludeNulls = false;
            return this;
        }

        @Nonnull
        public Builder breakLines() {
            this.breakLines = true;
            return this;
        }

        @Nonnull
        public Builder doNotBreakLines() {
            this.breakLines = false;
            return this;
        }

        @Nonnull
        public Builder withIndentation(int indentation) {
            this.indentation = Builder.validateIndentation(indentation);
            return this;
        }

        @Nonnull
        public Builder uppercaseForKeywords() {
            this.uppercaseForKeywords = true;
            return this;
        }

        @Nonnull
        public Builder lowercaseForKeywords() {
            this.uppercaseForKeywords = false;
            return this;
        }

        @Nonnull
        public Builder nameWithoutNulls() {
            this.nameWithoutNulls = true;
            return this;
        }

        @Nonnull
        public Builder doNotNameWithoutNulls() {
            this.nameWithoutNulls = false;
            return this;
        }

        @Nonnull
        public Builder withIdxPosition(@Nonnull IdxPosition idxPosition) {
            this.idxPosition = Objects.requireNonNull(idxPosition, "idxPosition cannot be null");
            return this;
        }

        @Nonnull
        public String toString() {
            return Builder.class.getSimpleName() + "{concurrently=" + this.concurrently + ", excludeNulls=" + this.excludeNulls + ", breakLines=" + this.breakLines + ", indentation=" + this.indentation + ", uppercaseForKeywords=" + this.uppercaseForKeywords + ", nameWithoutNulls=" + this.nameWithoutNulls + ", idxPosition=" + this.idxPosition + "}";
        }

        private static int validateIndentation(int indentation) {
            if (indentation < 0 || indentation > 8) {
                throw new IllegalArgumentException("indentation should be in the range [0, 8]");
            }
            return indentation;
        }
    }
}

