/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.generator;

import io.github.mfvanek.pg.generator.GeneratingOptions;
import io.github.mfvanek.pg.generator.IdxPosition;
import io.github.mfvanek.pg.generator.utils.NameUtils;
import io.github.mfvanek.pg.generator.utils.StringUtils;
import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.column.ColumnNameAware;
import io.github.mfvanek.pg.model.constraint.ForeignKey;
import io.github.mfvanek.pg.model.table.TableNameAware;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

class PgIdentifierNameGenerator {
    private static final String IDX = "idx";
    private static final String WITHOUT_NULLS = "without_nulls";
    private final GeneratingOptions options;
    private final String tableNameWithoutSchema;
    private final String columnsInIndex;
    private final boolean hasToAddWithoutNullsSuffix;

    private PgIdentifierNameGenerator(@Nonnull ForeignKey foreignKey, @Nonnull GeneratingOptions options) {
        Objects.requireNonNull(foreignKey, "foreignKey cannot be null");
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.tableNameWithoutSchema = NameUtils.getTableNameWithoutSchema((TableNameAware)foreignKey);
        this.columnsInIndex = foreignKey.getColumnsInConstraint().stream().map(Column::getColumnName).collect(Collectors.joining("_"));
        this.hasToAddWithoutNullsSuffix = options.isNameWithoutNulls() && options.isExcludeNulls() && foreignKey.getColumnsInConstraint().stream().anyMatch(ColumnNameAware::isNullable);
    }

    @Nonnull
    public String generateFullIndexName() {
        StringBuilder fullNameBuilder = new StringBuilder();
        this.addMainPart(fullNameBuilder);
        this.addWithoutNullsIfNeed(fullNameBuilder);
        return this.addIdxIfNeed(fullNameBuilder).toString();
    }

    @Nonnull
    public String generateTruncatedIndexName() {
        int remainingLength = this.options.isNeedToAddIdx() ? 63 - IDX.length() - "_".length() : 63;
        StringBuilder truncatedNameBuilder = new StringBuilder();
        if (this.tableNameWithoutSchema.length() + "_".length() + this.columnsInIndex.length() > remainingLength) {
            int hash = this.columnsInIndex.hashCode();
            Object columnsPart = hash < 0 ? "n" + Math.abs(hash) : String.valueOf(hash);
            remainingLength = remainingLength - "_".length() - ((String)columnsPart).length();
            truncatedNameBuilder.append(StringUtils.truncate(this.tableNameWithoutSchema, remainingLength)).append("_").append((String)columnsPart);
            remainingLength -= this.tableNameWithoutSchema.length();
        } else {
            this.addMainPart(truncatedNameBuilder);
        }
        if (remainingLength > WITHOUT_NULLS.length()) {
            this.addWithoutNullsIfNeed(truncatedNameBuilder);
        }
        return this.addIdxIfNeed(truncatedNameBuilder).toString();
    }

    private void addMainPart(@Nonnull StringBuilder nameBuilder) {
        nameBuilder.append(this.tableNameWithoutSchema).append("_").append(this.columnsInIndex);
    }

    private void addWithoutNullsIfNeed(@Nonnull StringBuilder nameBuilder) {
        if (this.hasToAddWithoutNullsSuffix) {
            nameBuilder.append("_").append(WITHOUT_NULLS);
        }
    }

    @Nonnull
    private StringBuilder addIdxIfNeed(@Nonnull StringBuilder nameBuilder) {
        if (this.options.isNeedToAddIdx()) {
            if (this.options.getIdxPosition() == IdxPosition.SUFFIX) {
                nameBuilder.append("_").append(IDX);
            } else {
                nameBuilder.insert(0, "idx_");
            }
        }
        return nameBuilder;
    }

    @Nonnull
    public static PgIdentifierNameGenerator of(@Nonnull ForeignKey foreignKey, @Nonnull GeneratingOptions options) {
        return new PgIdentifierNameGenerator(foreignKey, options);
    }
}

