/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.generator;

import io.github.mfvanek.pg.generator.AbstractOptionsAwareSqlGenerator;
import io.github.mfvanek.pg.generator.GeneratingOptions;
import io.github.mfvanek.pg.generator.PgIdentifierNameGenerator;
import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.column.ColumnNameAware;
import io.github.mfvanek.pg.model.constraint.ForeignKey;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

final class PgIndexOnForeignKeyGenerator
extends AbstractOptionsAwareSqlGenerator<ForeignKey> {
    public static final int MAX_IDENTIFIER_LENGTH = 63;

    PgIndexOnForeignKeyGenerator(@Nonnull GeneratingOptions options) {
        super(options);
    }

    @Override
    @Nonnull
    public String generate(@Nonnull ForeignKey foreignKey) {
        boolean hasToTruncate;
        Objects.requireNonNull(foreignKey, "foreignKey cannot be null");
        PgIdentifierNameGenerator nameGenerator = PgIdentifierNameGenerator.of(foreignKey, this.options);
        StringBuilder queryBuilder = new StringBuilder();
        String fullIndexName = nameGenerator.generateFullIndexName();
        boolean bl = hasToTruncate = fullIndexName.length() > 63;
        if (hasToTruncate) {
            this.appendFullIndexNameAsComment(queryBuilder, fullIndexName);
        }
        queryBuilder.append(this.keyword("create index ")).append(this.options.isConcurrently() ? this.keyword("concurrently ") : "").append(this.keyword("if not exists ")).append(hasToTruncate ? nameGenerator.generateTruncatedIndexName() : fullIndexName).append(this.options.isBreakLines() ? System.lineSeparator() : " ").append(this.options.isBreakLines() ? " ".repeat(this.options.getIndentation()) : "").append(this.keyword("on ")).append(foreignKey.getTableName()).append(" (").append(foreignKey.getColumnsInConstraint().stream().map(Column::getColumnName).collect(Collectors.joining(", "))).append(')');
        if (this.hasToExcludeNulls(foreignKey)) {
            this.excludeNulls(queryBuilder, foreignKey);
        }
        return queryBuilder.append(';').toString();
    }

    private void appendFullIndexNameAsComment(@Nonnull StringBuilder queryBuilder, @Nonnull String fullIndexName) {
        queryBuilder.append("/* ").append(fullIndexName).append(" */").append(this.options.isBreakLines() ? System.lineSeparator() : " ");
    }

    private boolean hasToExcludeNulls(@Nonnull ForeignKey foreignKey) {
        return this.options.isExcludeNulls() && foreignKey.getColumnsInConstraint().stream().anyMatch(ColumnNameAware::isNullable);
    }

    private void excludeNulls(@Nonnull StringBuilder queryBuilder, @Nonnull ForeignKey foreignKey) {
        queryBuilder.append(this.keyword(" where "));
        String columnsList = foreignKey.getColumnsInConstraint().stream().filter(ColumnNameAware::isNullable).map(Column::getColumnName).map(n -> n + this.keyword(" is not null")).collect(Collectors.joining(" and "));
        queryBuilder.append(columnsList);
    }
}

