/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.generator.utils;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringUtils.class);

    private StringUtils() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public static String truncate(@Nonnull String str, int maxWidth) {
        Objects.requireNonNull(str, "str cannot be null");
        if (maxWidth < 0) {
            throw new IllegalArgumentException("maxWith cannot be negative");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        LOGGER.trace("String {} will be truncated", (Object)str);
        return str.substring(0, maxWidth);
    }
}

