/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection;

import io.github.mfvanek.pg.connection.PgConnectionValidators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConnectionCredentials {
    private final SortedSet<String> connectionUrls;
    private final String userName;
    private final String password;

    private ConnectionCredentials(@Nonnull Collection<String> connectionUrls, @Nonnull String userName, @Nonnull String password) {
        ArrayList<String> defensiveCopy = new ArrayList<String>(Objects.requireNonNull(connectionUrls, "connectionUrls cannot be null"));
        PgConnectionValidators.connectionUrlsNotEmptyAndValid(defensiveCopy);
        this.connectionUrls = Collections.unmodifiableSortedSet(new TreeSet<String>(defensiveCopy));
        this.userName = PgConnectionValidators.userNameNotBlank(userName);
        this.password = PgConnectionValidators.passwordNotBlank(password);
    }

    @Nonnull
    public Collection<String> getConnectionUrls() {
        return this.connectionUrls;
    }

    @Nonnull
    public String getUserName() {
        return this.userName;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConnectionCredentials)) {
            return false;
        }
        ConnectionCredentials that = (ConnectionCredentials)other;
        return Objects.equals(this.connectionUrls, that.connectionUrls) && Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password);
    }

    public final int hashCode() {
        return Objects.hash(this.connectionUrls, this.userName, this.password);
    }

    @Nonnull
    public String toString() {
        return ConnectionCredentials.class.getSimpleName() + "{connectionUrls=" + this.connectionUrls + ", userName='" + this.userName + "', password='" + this.password + "'}";
    }

    @Nonnull
    public static ConnectionCredentials of(@Nonnull Collection<String> connectionUrls, @Nonnull String userName, @Nonnull String password) {
        return new ConnectionCredentials(connectionUrls, userName, password);
    }

    @Nonnull
    public static ConnectionCredentials ofUrl(@Nonnull String writeUrl, @Nonnull String userName, @Nonnull String password) {
        Set<String> connectionUrls = Set.of(PgConnectionValidators.pgUrlNotBlankAndValid(writeUrl, "writeUrl"));
        return new ConnectionCredentials(connectionUrls, userName, password);
    }
}

