/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection;

import io.github.mfvanek.pg.connection.ConnectionCredentials;
import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.connection.HighAvailabilityPgConnectionFactory;
import io.github.mfvanek.pg.connection.HighAvailabilityPgConnectionImpl;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgConnectionFactory;
import io.github.mfvanek.pg.connection.PgUrlParser;
import io.github.mfvanek.pg.connection.PrimaryHostDeterminer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class HighAvailabilityPgConnectionFactoryImpl
implements HighAvailabilityPgConnectionFactory {
    private final PgConnectionFactory pgConnectionFactory;
    private final PrimaryHostDeterminer primaryHostDeterminer;

    public HighAvailabilityPgConnectionFactoryImpl(@Nonnull PgConnectionFactory pgConnectionFactory, @Nonnull PrimaryHostDeterminer primaryHostDeterminer) {
        this.pgConnectionFactory = Objects.requireNonNull(pgConnectionFactory);
        this.primaryHostDeterminer = Objects.requireNonNull(primaryHostDeterminer);
    }

    @Override
    @Nonnull
    public HighAvailabilityPgConnection of(@Nonnull ConnectionCredentials credentials) {
        Objects.requireNonNull(credentials, "credentials cannot be null");
        LinkedHashMap<String, PgConnection> connectionsToAllHostsInCluster = new LinkedHashMap<String, PgConnection>();
        credentials.getConnectionUrls().forEach(url -> this.addDataSourcesForAllHostsFromUrl((Map<String, PgConnection>)connectionsToAllHostsInCluster, (String)url, credentials));
        PgConnection connectionToPrimary = this.findConnectionToPrimary(connectionsToAllHostsInCluster);
        return HighAvailabilityPgConnectionImpl.of(connectionToPrimary, connectionsToAllHostsInCluster.values());
    }

    private void addDataSourcesForAllHostsFromUrl(@Nonnull Map<String, PgConnection> connectionsToAllHostsInCluster, @Nonnull String anyUrl, @Nonnull ConnectionCredentials credentials) {
        List<Map.Entry<String, String>> allHosts = PgUrlParser.extractNameWithPortAndUrlForEachHost(anyUrl);
        for (Map.Entry<String, String> host : allHosts) {
            connectionsToAllHostsInCluster.computeIfAbsent(host.getKey(), h -> this.pgConnectionFactory.forUrl((String)host.getValue(), credentials.getUserName(), credentials.getPassword()));
        }
    }

    private PgConnection findConnectionToPrimary(Map<String, PgConnection> connectionsToAllHostsInCluster) {
        for (PgConnection pgConnection : connectionsToAllHostsInCluster.values()) {
            if (!this.primaryHostDeterminer.isPrimary(pgConnection)) continue;
            return pgConnection;
        }
        throw new NoSuchElementException("Connection to primary host not found in " + connectionsToAllHostsInCluster);
    }
}

