/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection;

import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgHost;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.sql.DataSource;

public class PgConnectionImpl
implements PgConnection {
    private final DataSource dataSource;
    private final PgHost host;

    private PgConnectionImpl(@Nonnull DataSource dataSource, @Nonnull PgHost host) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource cannot be null");
        this.host = Objects.requireNonNull(host, "host cannot be null");
    }

    @Override
    @Nonnull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @Nonnull
    public PgHost getHost() {
        return this.host;
    }

    @Nonnull
    public static PgConnection of(@Nonnull DataSource dataSource, @Nonnull PgHost host) {
        return new PgConnectionImpl(dataSource, host);
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PgConnection)) {
            return false;
        }
        PgConnection that = (PgConnection)other;
        return Objects.equals(this.host, that.getHost());
    }

    public final int hashCode() {
        return Objects.hash(this.host);
    }

    @Nonnull
    public String toString() {
        return PgConnectionImpl.class.getSimpleName() + "{host=" + this.host + "}";
    }
}

