/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection;

import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgConnectionValidators;
import io.github.mfvanek.pg.connection.PrimaryHostDeterminer;
import io.github.mfvanek.pg.connection.PrimaryHostDeterminerImpl;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighAvailabilityPgConnectionImpl
implements HighAvailabilityPgConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighAvailabilityPgConnectionImpl.class);
    private static final long DEFAULT_PRIMARY_REFRESH_INTERVAL_MILLISECONDS = 30000L;
    private final AtomicReference<PgConnection> cachedConnectionToPrimary = new AtomicReference();
    private final Set<PgConnection> connectionsToAllHostsInCluster;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final PrimaryHostDeterminer primaryHostDeterminer;

    private HighAvailabilityPgConnectionImpl(@Nonnull PgConnection connectionToPrimary, @Nonnull Collection<PgConnection> connectionsToAllHostsInCluster, @Nonnull PrimaryHostDeterminer primaryHostDeterminer) {
        this.primaryHostDeterminer = Objects.requireNonNull(primaryHostDeterminer);
        Objects.requireNonNull(connectionToPrimary, "connectionToPrimary");
        Set<PgConnection> defensiveCopy = Set.copyOf(Objects.requireNonNull(connectionsToAllHostsInCluster, "connectionsToAllHostsInCluster"));
        PgConnectionValidators.shouldContainsConnectionToPrimary(connectionToPrimary, defensiveCopy);
        this.cachedConnectionToPrimary.set(connectionToPrimary);
        this.connectionsToAllHostsInCluster = defensiveCopy;
    }

    @Override
    @Nonnull
    public PgConnection getConnectionToPrimary() {
        return this.cachedConnectionToPrimary.get();
    }

    @Override
    @Nonnull
    public Set<PgConnection> getConnectionsToAllHostsInCluster() {
        return this.connectionsToAllHostsInCluster;
    }

    @Nonnull
    public static HighAvailabilityPgConnection of(@Nonnull PgConnection connectionToPrimary) {
        return HighAvailabilityPgConnectionImpl.of(connectionToPrimary, Set.of(connectionToPrimary));
    }

    @Nonnull
    public static HighAvailabilityPgConnection of(@Nonnull PgConnection connectionToPrimary, @Nonnull Collection<PgConnection> connectionsToAllHostsInCluster) {
        return HighAvailabilityPgConnectionImpl.of(connectionToPrimary, connectionsToAllHostsInCluster, 30000L);
    }

    @Nonnull
    public static HighAvailabilityPgConnection of(@Nonnull PgConnection connectionToPrimary, @Nonnull Collection<PgConnection> connectionsToAllHostsInCluster, long primaryRefreshIntervalMilliseconds) {
        PrimaryHostDeterminerImpl primaryHostDeterminer = new PrimaryHostDeterminerImpl();
        HighAvailabilityPgConnectionImpl highAvailabilityPgConnection = new HighAvailabilityPgConnectionImpl(connectionToPrimary, connectionsToAllHostsInCluster, primaryHostDeterminer);
        highAvailabilityPgConnection.startPrimaryUpdater(primaryRefreshIntervalMilliseconds);
        return highAvailabilityPgConnection;
    }

    private void startPrimaryUpdater(long primaryRefreshIntervalMilliseconds) {
        if (this.getConnectionsToAllHostsInCluster().size() >= 2) {
            this.executorService.scheduleWithFixedDelay(this::updateConnectionToPrimary, primaryRefreshIntervalMilliseconds, primaryRefreshIntervalMilliseconds, TimeUnit.MILLISECONDS);
        } else {
            LOGGER.debug("Single node. There's no point to monitor primary node.");
        }
    }

    private void updateConnectionToPrimary() {
        this.connectionsToAllHostsInCluster.forEach(pgConnection -> {
            try {
                if (this.primaryHostDeterminer.isPrimary((PgConnection)pgConnection)) {
                    this.cachedConnectionToPrimary.set((PgConnection)pgConnection);
                    LOGGER.debug("Current primary is {}", (Object)pgConnection.getHost().getPgUrl());
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception during primary detection for host {}", (Object)pgConnection.getHost(), (Object)e);
            }
        });
    }
}

