/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection;

import io.github.mfvanek.pg.connection.PgConnectionValidators;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

final class PgConnectionHelper {
    private PgConnectionHelper() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    static DataSource createDataSource(@Nonnull String pgUrl, @Nonnull String userName, @Nonnull String password) {
        PgConnectionValidators.pgUrlNotBlankAndValid(pgUrl, "pgUrl");
        PgConnectionValidators.userNameNotBlank(userName);
        PgConnectionValidators.passwordNotBlank(password);
        BasicDataSource dataSource = new BasicDataSource();
        PgConnectionHelper.setCommonProperties(dataSource, userName, password);
        dataSource.setUrl(pgUrl);
        return dataSource;
    }

    private static void setCommonProperties(@Nonnull BasicDataSource dataSource, @Nonnull String userName, @Nonnull String password) {
        dataSource.setDriverClassName("org.postgresql.Driver");
        dataSource.setUsername(userName);
        dataSource.setPassword(password);
        dataSource.setValidationQuery("select 1");
        dataSource.setMaxTotal(1);
        dataSource.setMaxIdle(1);
        dataSource.setMaxOpenPreparedStatements(1);
    }
}

