/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection;

import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgConnectionFactory;
import io.github.mfvanek.pg.connection.PgConnectionHelper;
import io.github.mfvanek.pg.connection.PgConnectionImpl;
import io.github.mfvanek.pg.connection.PgHostImpl;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgConnectionFactoryImpl
implements PgConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgConnectionFactoryImpl.class);

    @Override
    @Nonnull
    public PgConnection forUrl(@Nonnull String pgUrl, @Nonnull String userName, @Nonnull String password) {
        LOGGER.debug("Creating {} with pgUrl = {}, userName = {}, password = {}", new Object[]{PgConnection.class.getSimpleName(), pgUrl, userName, "*****"});
        DataSource dataSource = this.dataSourceFor(pgUrl, userName, password);
        return PgConnectionImpl.of(dataSource, PgHostImpl.ofUrl(pgUrl));
    }

    @Override
    @Nonnull
    public DataSource dataSourceFor(@Nonnull String pgUrl, @Nonnull String userName, @Nonnull String password) {
        return PgConnectionHelper.createDataSource(pgUrl, userName, password);
    }
}

