/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection;

import io.github.mfvanek.pg.connection.PgConnectionValidators;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class PgUrlParser {
    public static final String URL_HEADER = "jdbc:postgresql://";
    private static final String PG_URL = "pgUrl";
    private static final Map<String, String> DEFAULT_URL_PARAMETERS = Map.ofEntries(Map.entry("targetServerType", "primary"), Map.entry("hostRecheckSeconds", "2"), Map.entry("connectTimeout", "1"), Map.entry("socketTimeout", "600"));

    private PgUrlParser() {
        throw new UnsupportedOperationException();
    }

    static boolean isReplicaUrl(@Nonnull String pgUrl) {
        PgConnectionValidators.pgUrlNotBlankAndValid(pgUrl, PG_URL);
        return pgUrl.contains("targetServerType=slave") || pgUrl.contains("targetServerType=secondary");
    }

    @Nonnull
    static List<Map.Entry<String, String>> extractNameWithPortAndUrlForEachHost(@Nonnull String pgUrl) {
        PgConnectionValidators.pgUrlNotBlankAndValid(pgUrl, PG_URL);
        int lastIndex = pgUrl.lastIndexOf(47);
        String dbNameWithParams = pgUrl.substring(lastIndex);
        String dbNameWithParamsForReplica = PgUrlParser.convertToReplicaConnectionString(dbNameWithParams);
        String allHostsWithPort = PgUrlParser.extractAllHostsWithPort(pgUrl);
        return Arrays.stream(allHostsWithPort.split(",")).distinct().sorted().map(h -> Map.entry(h, URL_HEADER + h + dbNameWithParamsForReplica)).collect(Collectors.toUnmodifiableList());
    }

    @Nonnull
    private static String convertToReplicaConnectionString(@Nonnull String dbNameWithParams) {
        List<String> primaryServerTypes = List.of("targetServerType=primary", "targetServerType=master");
        for (String serverType : primaryServerTypes) {
            if (!dbNameWithParams.contains(serverType)) continue;
            return dbNameWithParams.replace(serverType, "targetServerType=any");
        }
        return dbNameWithParams;
    }

    @Nonnull
    static List<Map.Entry<String, Integer>> extractHostNames(@Nonnull String pgUrl) {
        PgConnectionValidators.pgUrlNotBlankAndValid(pgUrl, PG_URL);
        String allHostsWithPort = PgUrlParser.extractAllHostsWithPort(pgUrl);
        return Arrays.stream(allHostsWithPort.split(",")).filter(Predicate.not(String::isBlank)).map(h -> {
            String[] hostToPort = h.split(":");
            return Map.entry(hostToPort[0], Integer.parseInt(hostToPort[1]));
        }).distinct().sorted(Map.Entry.comparingByKey()).collect(Collectors.toUnmodifiableList());
    }

    @Nonnull
    static String extractDatabaseName(@Nonnull Set<String> pgUrls) {
        int lastIndexOfSlash;
        String pgUrl = pgUrls.iterator().next();
        String dbNameWithParams = pgUrl.substring(lastIndexOfSlash = pgUrl.lastIndexOf(47));
        int lastIndex = dbNameWithParams.lastIndexOf(63);
        if (lastIndex >= 0) {
            return dbNameWithParams.substring(0, lastIndex);
        }
        return dbNameWithParams;
    }

    @Nonnull
    private static String extractAllHostsWithPort(@Nonnull String pgUrl) {
        int lastIndex = pgUrl.lastIndexOf(47);
        if (lastIndex >= URL_HEADER.length()) {
            return pgUrl.substring(URL_HEADER.length(), lastIndex);
        }
        return pgUrl.substring(URL_HEADER.length());
    }

    @Nonnull
    public static String buildCommonUrlToPrimary(@Nonnull String firstPgUrl, @Nonnull String secondPgUrl) {
        return PgUrlParser.buildCommonUrlToPrimary(Set.of(firstPgUrl, secondPgUrl));
    }

    @Nonnull
    public static String buildCommonUrlToPrimary(@Nonnull String firstPgUrl, @Nonnull String secondPgUrl, @Nonnull Map<String, String> urlParameters) {
        return PgUrlParser.buildCommonUrlToPrimary(Set.of(firstPgUrl, secondPgUrl), urlParameters);
    }

    @Nonnull
    public static String buildCommonUrlToPrimary(@Nonnull Set<String> pgUrls) {
        return PgUrlParser.buildCommonUrlToPrimary(pgUrls, Map.of());
    }

    @Nonnull
    public static String buildCommonUrlToPrimary(@Nonnull Set<String> pgUrls, @Nonnull Map<String, String> urlParameters) {
        String additionalUrlParams = PgUrlParser.constructUrlParameters(urlParameters);
        return URL_HEADER + pgUrls.stream().map(PgUrlParser::extractAllHostsWithPort).sorted().collect(Collectors.joining(",")) + PgUrlParser.extractDatabaseName(pgUrls) + additionalUrlParams;
    }

    @Nonnull
    static String constructUrlParameters(@Nonnull Map<String, String> urlParameters) {
        TreeMap<String, String> jointUrlParameters = new TreeMap<String, String>(urlParameters);
        DEFAULT_URL_PARAMETERS.forEach(jointUrlParameters::putIfAbsent);
        String additionalParameters = jointUrlParameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        return "?" + additionalParameters;
    }
}

