/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection;

import io.github.mfvanek.pg.connection.PgConnectionValidators;
import io.github.mfvanek.pg.connection.PgHost;
import io.github.mfvanek.pg.connection.PgUrlParser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PgHostImpl
implements PgHost {
    private final String pgUrl;
    private final String hostName;
    private final int port;
    private final boolean maybePrimary;

    private PgHostImpl(@Nonnull String pgUrl, @Nonnull String hostName, int port, boolean maybePrimary) {
        this.pgUrl = PgConnectionValidators.pgUrlNotBlankAndValid(pgUrl, "pgUrl");
        this.hostName = PgConnectionValidators.hostNameNotBlank(hostName);
        this.port = PgConnectionValidators.portInAcceptableRange(port);
        this.maybePrimary = maybePrimary;
    }

    @Override
    @Nonnull
    public String getPgUrl() {
        return this.pgUrl;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.hostName;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean canBePrimary() {
        return this.maybePrimary;
    }

    @Nonnull
    public static PgHost ofUrl(@Nonnull String pgUrl) {
        List<Map.Entry<String, Integer>> extractHostNames = PgUrlParser.extractHostNames(pgUrl);
        if (extractHostNames.size() > 1) {
            throw new IllegalArgumentException("pgUrl couldn't contain multiple hosts");
        }
        Map.Entry<String, Integer> host = extractHostNames.get(0);
        return new PgHostImpl(pgUrl, host.getKey(), host.getValue(), !PgUrlParser.isReplicaUrl(pgUrl));
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PgHostImpl)) {
            return false;
        }
        PgHostImpl pgHost = (PgHostImpl)other;
        return this.port == pgHost.port && Objects.equals(this.hostName, pgHost.hostName);
    }

    public final int hashCode() {
        return Objects.hash(this.hostName, this.port);
    }

    @Nonnull
    public String toString() {
        return PgHostImpl.class.getSimpleName() + "{pgUrl='" + this.pgUrl + "', hostName=" + this.hostName + ", port=" + this.port + ", maybePrimary=" + this.maybePrimary + "}";
    }
}

