/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection;

import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PrimaryHostDeterminer;
import io.github.mfvanek.pg.connection.PrimaryHostDeterminerImpl;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HighAvailabilityPgConnectionImpl
implements HighAvailabilityPgConnection {
    private static final Logger LOGGER = Logger.getLogger(HighAvailabilityPgConnectionImpl.class.getName());
    private static final long DEFAULT_PRIMARY_REFRESH_INTERVAL_MILLISECONDS = 30000L;
    private final AtomicReference<PgConnection> cachedConnectionToPrimary = new AtomicReference();
    private final Set<PgConnection> connectionsToAllHostsInCluster;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final PrimaryHostDeterminer primaryHostDeterminer;

    private HighAvailabilityPgConnectionImpl(PgConnection connectionToPrimary, Collection<PgConnection> connectionsToAllHostsInCluster, PrimaryHostDeterminer primaryHostDeterminer) {
        this.primaryHostDeterminer = Objects.requireNonNull(primaryHostDeterminer);
        Objects.requireNonNull(connectionToPrimary, "connectionToPrimary");
        Set<PgConnection> defensiveCopy = Set.copyOf(Objects.requireNonNull(connectionsToAllHostsInCluster, "connectionsToAllHostsInCluster"));
        HighAvailabilityPgConnectionImpl.shouldContainsConnectionToPrimary(connectionToPrimary, defensiveCopy);
        this.cachedConnectionToPrimary.set(connectionToPrimary);
        this.connectionsToAllHostsInCluster = defensiveCopy;
    }

    @Override
    public PgConnection getConnectionToPrimary() {
        return this.cachedConnectionToPrimary.get();
    }

    @Override
    public Set<PgConnection> getConnectionsToAllHostsInCluster() {
        return this.connectionsToAllHostsInCluster;
    }

    public static HighAvailabilityPgConnection of(PgConnection connectionToPrimary) {
        return HighAvailabilityPgConnectionImpl.of(connectionToPrimary, Set.of(connectionToPrimary));
    }

    public static HighAvailabilityPgConnection of(PgConnection connectionToPrimary, Collection<PgConnection> connectionsToAllHostsInCluster) {
        return HighAvailabilityPgConnectionImpl.of(connectionToPrimary, connectionsToAllHostsInCluster, 30000L);
    }

    public static HighAvailabilityPgConnection of(PgConnection connectionToPrimary, Collection<PgConnection> connectionsToAllHostsInCluster, long primaryRefreshIntervalMilliseconds) {
        PrimaryHostDeterminerImpl primaryHostDeterminer = new PrimaryHostDeterminerImpl();
        HighAvailabilityPgConnectionImpl highAvailabilityPgConnection = new HighAvailabilityPgConnectionImpl(connectionToPrimary, connectionsToAllHostsInCluster, primaryHostDeterminer);
        highAvailabilityPgConnection.startPrimaryUpdater(primaryRefreshIntervalMilliseconds);
        return highAvailabilityPgConnection;
    }

    private void startPrimaryUpdater(long primaryRefreshIntervalMilliseconds) {
        if (this.getConnectionsToAllHostsInCluster().size() >= 2) {
            this.executorService.scheduleWithFixedDelay(this::updateConnectionToPrimary, primaryRefreshIntervalMilliseconds, primaryRefreshIntervalMilliseconds, TimeUnit.MILLISECONDS);
        } else {
            LOGGER.fine("Single node. There's no point to monitor primary node.");
        }
    }

    private void updateConnectionToPrimary() {
        this.connectionsToAllHostsInCluster.forEach(pgConnection -> {
            try {
                if (this.primaryHostDeterminer.isPrimary((PgConnection)pgConnection)) {
                    this.cachedConnectionToPrimary.set((PgConnection)pgConnection);
                    LOGGER.fine(() -> "Current primary is " + pgConnection.getHost().getPgUrl());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, () -> "Exception during primary detection for host " + pgConnection.getHost());
            }
        });
    }

    private static void shouldContainsConnectionToPrimary(PgConnection connectionToPrimary, Set<PgConnection> connectionsToAllHostsInCluster) {
        if (!connectionsToAllHostsInCluster.contains(connectionToPrimary)) {
            throw new IllegalArgumentException("connectionsToAllHostsInCluster have to contain a connection to the primary");
        }
    }
}

