/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection;

import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.exception.PgSqlException;
import io.github.mfvanek.pg.connection.host.PgHost;
import io.github.mfvanek.pg.connection.host.PgHostImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;

public class PgConnectionImpl
implements PgConnection {
    private final DataSource dataSource;
    private final PgHost host;

    private PgConnectionImpl(DataSource dataSource, PgHost host) {
        this.dataSource = PgConnectionImpl.validateDataSource(dataSource);
        this.host = Objects.requireNonNull(host, "host cannot be null");
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public PgHost getHost() {
        return this.host;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PgConnection)) {
            return false;
        }
        PgConnection that = (PgConnection)other;
        return Objects.equals(this.host, that.getHost());
    }

    public final int hashCode() {
        return Objects.hash(this.host);
    }

    public String toString() {
        return PgConnectionImpl.class.getSimpleName() + "{host=" + this.host + "}";
    }

    public static PgConnection of(DataSource dataSource, PgHost host) {
        return new PgConnectionImpl(dataSource, host);
    }

    public static PgConnection ofUrl(DataSource dataSource, @Nullable String databaseUrl) {
        PgHost host;
        block9: {
            if (databaseUrl == null || PgConnectionImpl.needToGetUrlFromMetaData(databaseUrl)) {
                try (Connection connection = PgConnectionImpl.validateDataSource(dataSource).getConnection();){
                    host = PgHostImpl.ofUrl(connection.getMetaData().getURL());
                    break block9;
                }
                catch (SQLException ex) {
                    throw new PgSqlException(ex);
                }
            }
            host = PgHostImpl.ofUrl(databaseUrl);
        }
        return new PgConnectionImpl(dataSource, host);
    }

    private static DataSource validateDataSource(DataSource dataSource) {
        return Objects.requireNonNull(dataSource, "dataSource cannot be null");
    }

    private static boolean needToGetUrlFromMetaData(String databaseUrl) {
        return databaseUrl.isBlank() || databaseUrl.startsWith("jdbc:tc:postgresql:");
    }
}

