/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection.factory;

import io.github.mfvanek.pg.connection.factory.PgConnectionValidators;
import io.github.mfvanek.pg.connection.host.PgUrlValidators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ConnectionCredentials {
    private final SortedSet<String> connectionUrls;
    private final String userName;
    private final String password;

    private ConnectionCredentials(Collection<String> connectionUrls, String userName, String password) {
        ArrayList<String> defensiveCopy = new ArrayList<String>(Objects.requireNonNull(connectionUrls, "connectionUrls cannot be null"));
        PgConnectionValidators.connectionUrlsNotEmptyAndValid(defensiveCopy);
        this.connectionUrls = Collections.unmodifiableSortedSet(new TreeSet<String>(defensiveCopy));
        this.userName = PgConnectionValidators.userNameNotBlank(userName);
        this.password = PgConnectionValidators.passwordNotBlank(password);
    }

    public Collection<String> getConnectionUrls() {
        return this.connectionUrls;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConnectionCredentials)) {
            return false;
        }
        ConnectionCredentials that = (ConnectionCredentials)other;
        return Objects.equals(this.connectionUrls, that.connectionUrls) && Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.connectionUrls, this.userName, this.password);
    }

    public String toString() {
        return ConnectionCredentials.class.getSimpleName() + "{connectionUrls=" + this.connectionUrls + ", userName='" + this.userName + "', password='" + this.password + "'}";
    }

    public static ConnectionCredentials of(Collection<String> connectionUrls, String userName, String password) {
        return new ConnectionCredentials(connectionUrls, userName, password);
    }

    public static ConnectionCredentials ofUrl(String writeUrl, String userName, String password) {
        Set<String> connectionUrls = Set.of(PgUrlValidators.pgUrlNotBlankAndValid(writeUrl, "writeUrl"));
        return new ConnectionCredentials(connectionUrls, userName, password);
    }
}

