/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection.factory;

import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgConnectionImpl;
import io.github.mfvanek.pg.connection.factory.PgConnectionFactory;
import io.github.mfvanek.pg.connection.factory.PgConnectionHelper;
import io.github.mfvanek.pg.connection.host.PgHostImpl;
import java.util.Locale;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class PgConnectionFactoryImpl
implements PgConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(PgConnectionFactoryImpl.class.getName());

    @Override
    public PgConnection forUrl(String pgUrl, String userName, String password) {
        LOGGER.fine(() -> String.format(Locale.ROOT, "Creating %s with pgUrl = %s, userName = %s, password = %s", PgConnection.class.getSimpleName(), pgUrl, userName, "*****"));
        DataSource dataSource = this.dataSourceFor(pgUrl, userName, password);
        return PgConnectionImpl.of(dataSource, PgHostImpl.ofUrl(pgUrl));
    }

    @Override
    public DataSource dataSourceFor(String pgUrl, String userName, String password) {
        return PgConnectionHelper.createDataSource(pgUrl, userName, password);
    }
}

