/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection.factory;

import io.github.mfvanek.pg.connection.factory.PgConnectionValidators;
import io.github.mfvanek.pg.connection.host.PgUrlValidators;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

final class PgConnectionHelper {
    private PgConnectionHelper() {
        throw new UnsupportedOperationException();
    }

    static DataSource createDataSource(String pgUrl, String userName, String password) {
        PgUrlValidators.pgUrlNotBlankAndValid(pgUrl, "pgUrl");
        PgConnectionValidators.userNameNotBlank(userName);
        PgConnectionValidators.passwordNotBlank(password);
        BasicDataSource dataSource = new BasicDataSource();
        PgConnectionHelper.setCommonProperties(dataSource, userName, password);
        dataSource.setUrl(pgUrl);
        return dataSource;
    }

    private static void setCommonProperties(BasicDataSource dataSource, String userName, String password) {
        dataSource.setDriverClassName("org.postgresql.Driver");
        dataSource.setUsername(userName);
        dataSource.setPassword(password);
        dataSource.setValidationQuery("select 1");
        dataSource.setMaxTotal(1);
        dataSource.setMaxIdle(1);
        dataSource.setMaxOpenPreparedStatements(1);
    }
}

