/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection.factory;

import io.github.mfvanek.pg.connection.host.PgUrlValidators;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.Objects;

final class PgConnectionValidators {
    private PgConnectionValidators() {
        throw new UnsupportedOperationException();
    }

    static String userNameNotBlank(String userName) {
        Validators.notBlank((String)userName, (String)"userName");
        return userName;
    }

    static String passwordNotBlank(String password) {
        Validators.notBlank((String)password, (String)"password");
        return password;
    }

    static void connectionUrlsNotEmptyAndValid(Collection<String> connectionUrls) {
        Objects.requireNonNull(connectionUrls, "connectionUrls");
        if (connectionUrls.isEmpty()) {
            throw new IllegalArgumentException("connectionUrls have to contain at least one url");
        }
        connectionUrls.forEach(url -> PgUrlValidators.pgUrlNotBlankAndValid(url, "connectionUrl"));
    }
}

