/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection.host;

import io.github.mfvanek.pg.connection.host.PgHost;
import io.github.mfvanek.pg.connection.host.PgUrlParser;
import io.github.mfvanek.pg.connection.host.PgUrlValidators;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class PgHostImpl
implements PgHost {
    private final String pgUrl;
    private final String hostName;
    private final int port;
    private final boolean maybePrimary;

    private PgHostImpl(String pgUrl, String hostName, int port, boolean maybePrimary) {
        this.pgUrl = PgUrlValidators.pgUrlNotBlankAndValid(pgUrl);
        this.hostName = PgUrlValidators.hostNameNotBlank(hostName);
        this.port = PgUrlValidators.portInAcceptableRange(port);
        this.maybePrimary = maybePrimary;
    }

    @Override
    public String getPgUrl() {
        return this.pgUrl;
    }

    @Override
    public String getName() {
        return this.hostName;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean canBePrimary() {
        return this.maybePrimary;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PgHostImpl)) {
            return false;
        }
        PgHostImpl pgHost = (PgHostImpl)other;
        return this.port == pgHost.port && Objects.equals(this.hostName, pgHost.hostName);
    }

    public int hashCode() {
        return Objects.hash(this.hostName, this.port);
    }

    public String toString() {
        return PgHostImpl.class.getSimpleName() + "{pgUrl='" + this.pgUrl + "', hostName=" + this.hostName + ", port=" + this.port + ", maybePrimary=" + this.maybePrimary + "}";
    }

    public static PgHost ofUrl(String pgUrl) {
        List<Map.Entry<String, Integer>> extractHostNames = PgUrlParser.extractHostNames(pgUrl);
        if (extractHostNames.size() > 1) {
            throw new IllegalArgumentException("pgUrl couldn't contain multiple hosts");
        }
        Map.Entry<String, Integer> host = extractHostNames.get(0);
        return new PgHostImpl(pgUrl, host.getKey(), host.getValue(), !PgUrlParser.isReplicaUrl(pgUrl));
    }
}

