/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection.host;

import io.github.mfvanek.pg.connection.host.PgUrlValidators;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class PgUrlParser {
    public static final String URL_HEADER = "jdbc:postgresql://";
    public static final String TESTCONTAINERS_PG_URL_PREFIX = "jdbc:tc:postgresql:";
    private static final Map<String, String> DEFAULT_URL_PARAMETERS = Map.ofEntries(Map.entry("targetServerType", "primary"), Map.entry("hostRecheckSeconds", "2"), Map.entry("connectTimeout", "1"), Map.entry("socketTimeout", "600"));

    private PgUrlParser() {
        throw new UnsupportedOperationException();
    }

    static boolean isReplicaUrl(String pgUrl) {
        PgUrlValidators.pgUrlNotBlankAndValid(pgUrl);
        return pgUrl.contains("targetServerType=slave") || pgUrl.contains("targetServerType=secondary");
    }

    public static List<Map.Entry<String, String>> extractNameWithPortAndUrlForEachHost(String pgUrl) {
        PgUrlValidators.pgUrlNotBlankAndValid(pgUrl);
        int lastIndex = pgUrl.lastIndexOf(47);
        String dbNameWithParams = pgUrl.substring(lastIndex);
        String dbNameWithParamsForReplica = PgUrlParser.convertToReplicaConnectionString(dbNameWithParams);
        String allHostsWithPort = PgUrlParser.extractAllHostsWithPort(pgUrl);
        return Arrays.stream(allHostsWithPort.split(",")).distinct().sorted().map(h -> Map.entry(h, URL_HEADER + h + dbNameWithParamsForReplica)).collect(Collectors.toUnmodifiableList());
    }

    private static String convertToReplicaConnectionString(String dbNameWithParams) {
        List<String> primaryServerTypes = List.of("targetServerType=primary", "targetServerType=master");
        for (String serverType : primaryServerTypes) {
            if (!dbNameWithParams.contains(serverType)) continue;
            return dbNameWithParams.replace(serverType, "targetServerType=any");
        }
        return dbNameWithParams;
    }

    static List<Map.Entry<String, Integer>> extractHostNames(String pgUrl) {
        String allHostsWithPort = PgUrlParser.extractAllHostsWithPort(PgUrlValidators.pgUrlNotBlankAndValid(pgUrl));
        return Arrays.stream(allHostsWithPort.split(",")).filter(Predicate.not(String::isBlank)).map(h -> {
            String[] hostToPort = h.split(":");
            return Map.entry(hostToPort[0], Integer.valueOf(hostToPort[1]));
        }).distinct().sorted(Map.Entry.comparingByKey()).collect(Collectors.toUnmodifiableList());
    }

    static String extractDatabaseName(Set<String> pgUrls) {
        int lastIndexOfSlash;
        String pgUrl = pgUrls.iterator().next();
        String dbNameWithParams = pgUrl.substring(lastIndexOfSlash = pgUrl.lastIndexOf(47));
        int lastIndex = dbNameWithParams.lastIndexOf(63);
        if (lastIndex > 1) {
            return dbNameWithParams.substring(0, lastIndex);
        }
        if (lastIndex == 1) {
            throw new IllegalArgumentException("pgUrls contains invalid connection string " + pgUrl);
        }
        return dbNameWithParams;
    }

    private static String extractAllHostsWithPort(String pgUrl) {
        int lastIndex = pgUrl.lastIndexOf(47);
        if (lastIndex >= URL_HEADER.length()) {
            return pgUrl.substring(URL_HEADER.length(), lastIndex);
        }
        return pgUrl.substring(URL_HEADER.length());
    }

    public static String buildCommonUrlToPrimary(String firstPgUrl, String secondPgUrl) {
        return PgUrlParser.buildCommonUrlToPrimary(Set.of(firstPgUrl, secondPgUrl));
    }

    public static String buildCommonUrlToPrimary(String firstPgUrl, String secondPgUrl, Map<String, String> urlParameters) {
        return PgUrlParser.buildCommonUrlToPrimary(Set.of(firstPgUrl, secondPgUrl), urlParameters);
    }

    public static String buildCommonUrlToPrimary(Set<String> pgUrls) {
        return PgUrlParser.buildCommonUrlToPrimary(pgUrls, Map.of());
    }

    public static String buildCommonUrlToPrimary(Set<String> pgUrls, Map<String, String> urlParameters) {
        String additionalUrlParams = PgUrlParser.constructUrlParameters(urlParameters);
        return URL_HEADER + pgUrls.stream().map(PgUrlParser::extractAllHostsWithPort).sorted().collect(Collectors.joining(",")) + PgUrlParser.extractDatabaseName(pgUrls) + additionalUrlParams;
    }

    static String constructUrlParameters(Map<String, String> urlParameters) {
        TreeMap<String, String> jointUrlParameters = new TreeMap<String, String>(urlParameters);
        DEFAULT_URL_PARAMETERS.forEach(jointUrlParameters::putIfAbsent);
        String additionalParameters = jointUrlParameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        return "?" + additionalParameters;
    }
}

