/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection.host;

import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;

public final class PgUrlValidators {
    private PgUrlValidators() {
        throw new UnsupportedOperationException();
    }

    public static String pgUrlNotBlankAndValid(String pgUrl, String argumentName) {
        Validators.notBlank((String)pgUrl, (String)argumentName);
        if (!Objects.requireNonNull(pgUrl).startsWith("jdbc:postgresql://")) {
            throw new IllegalArgumentException(argumentName + " has invalid format");
        }
        return pgUrl;
    }

    static String pgUrlNotBlankAndValid(String pgUrl) {
        return PgUrlValidators.pgUrlNotBlankAndValid(pgUrl, "pgUrl");
    }

    static String hostNameNotBlank(String hostName) {
        Validators.notBlank((String)hostName, (String)"hostName");
        return hostName;
    }

    static int portInAcceptableRange(int port) {
        if (port < 1024 || port > 65535) {
            throw new IllegalArgumentException("the port number must be in the range from 1024 to 65535");
        }
        return port;
    }
}

