/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.connection;

import io.github.mfvanek.pg.connection.PgConnection;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

final class PgConnectionValidators {
    private PgConnectionValidators() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    static String pgUrlNotBlankAndValid(@Nonnull String pgUrl, @Nonnull String argumentName) {
        PgConnectionValidators.notBlank(pgUrl, argumentName);
        if (!Objects.requireNonNull(pgUrl).startsWith("jdbc:postgresql://")) {
            throw new IllegalArgumentException(argumentName + " has invalid format");
        }
        return pgUrl;
    }

    @Nonnull
    static String userNameNotBlank(@Nonnull String userName) {
        PgConnectionValidators.notBlank(userName, "userName");
        return userName;
    }

    @Nonnull
    static String passwordNotBlank(@Nonnull String password) {
        PgConnectionValidators.notBlank(password, "password");
        return password;
    }

    static void connectionUrlsNotEmptyAndValid(@Nonnull Collection<String> connectionUrls) {
        Objects.requireNonNull(connectionUrls, "connectionUrls");
        if (connectionUrls.isEmpty()) {
            throw new IllegalArgumentException("connectionUrls have to contain at least one url");
        }
        connectionUrls.forEach(url -> PgConnectionValidators.pgUrlNotBlankAndValid(url, "connectionUrl"));
    }

    static void shouldContainsConnectionToPrimary(@Nonnull PgConnection connectionToPrimary, @Nonnull Set<PgConnection> connectionsToAllHostsInCluster) {
        if (!connectionsToAllHostsInCluster.contains(connectionToPrimary)) {
            throw new IllegalArgumentException("connectionsToAllHostsInCluster have to contain a connection to the primary");
        }
    }

    static int portInAcceptableRange(int port) {
        if (port < 1024 || port > 65535) {
            throw new IllegalArgumentException("the port number must be in the range from 1024 to 65535");
        }
        return port;
    }

    @Nonnull
    static String hostNameNotBlank(@Nonnull String hostName) {
        PgConnectionValidators.notBlank(hostName, "hostName");
        return hostName;
    }

    private static void notBlank(@Nonnull String argumentValue, @Nonnull String argumentName) {
        if (Objects.requireNonNull(argumentValue, argumentName + " cannot be null").isBlank()) {
            throw new IllegalArgumentException(argumentName + " cannot be blank or empty");
        }
    }
}

