/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.index.IndexNameAware;
import io.github.mfvanek.pg.model.table.TableNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Index
implements DbObject,
TableNameAware,
IndexNameAware,
Comparable<Index> {
    private final String tableName;
    private final String indexName;

    protected Index(@Nonnull String tableName, @Nonnull String indexName) {
        this.tableName = Validators.tableNameNotBlank(tableName);
        this.indexName = Validators.indexNameNotBlank(indexName);
    }

    @Override
    @Nonnull
    public final String getName() {
        return this.getIndexName();
    }

    @Override
    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @Nonnull
    public String getIndexName() {
        return this.indexName;
    }

    @Nonnull
    public String toString() {
        return Index.class.getSimpleName() + "{" + this.innerToString() + "}";
    }

    protected String innerToString() {
        return "tableName='" + this.tableName + "', indexName='" + this.indexName + "'";
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Index)) {
            return false;
        }
        Index that = (Index)other;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.indexName, that.indexName);
    }

    public final int hashCode() {
        return Objects.hash(this.tableName, this.indexName);
    }

    @Override
    public int compareTo(@Nonnull Index other) {
        Objects.requireNonNull(other, "other cannot be null");
        if (!this.tableName.equals(other.tableName)) {
            return this.tableName.compareTo(other.tableName);
        }
        return this.indexName.compareTo(other.indexName);
    }

    public static Index of(@Nonnull String tableName, @Nonnull String indexName) {
        return new Index(tableName, indexName);
    }
}

