/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.index.IndexWithSize;
import io.github.mfvanek.pg.model.validation.Validators;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class UnusedIndex
extends IndexWithSize {
    private final long indexScans;

    private UnusedIndex(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes, long indexScans) {
        super(tableName, indexName, indexSizeInBytes);
        this.indexScans = Validators.countNotNegative(indexScans, "indexScans");
    }

    public long getIndexScans() {
        return this.indexScans;
    }

    @Override
    @Nonnull
    public String toString() {
        return UnusedIndex.class.getSimpleName() + "{" + this.innerToString() + ", indexScans=" + this.indexScans + "}";
    }

    public static UnusedIndex of(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes, long indexScans) {
        return new UnusedIndex(tableName, indexName, indexSizeInBytes, indexScans);
    }
}

