/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.column;

import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.column.ColumnNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Column
implements DbObject,
ColumnNameAware,
Comparable<Column> {
    private final String tableName;
    private final String columnName;
    private final boolean notNull;

    protected Column(@Nonnull String tableName, @Nonnull String columnName, boolean notNull) {
        this.tableName = Validators.tableNameNotBlank(tableName);
        this.columnName = Validators.notBlank(columnName, "columnName");
        this.notNull = notNull;
    }

    @Override
    @Nonnull
    public final String getName() {
        return this.getColumnName();
    }

    @Override
    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @Nonnull
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Nonnull
    public String toString() {
        return Column.class.getSimpleName() + "{tableName='" + this.tableName + "', columnName='" + this.columnName + "', notNull=" + this.notNull + "}";
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Column)) {
            return false;
        }
        Column that = (Column)other;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.columnName, that.columnName) && this.notNull == that.notNull;
    }

    public final int hashCode() {
        return Objects.hash(this.tableName, this.columnName, this.notNull);
    }

    @Override
    public int compareTo(@Nonnull Column other) {
        Objects.requireNonNull(other, "other cannot be null");
        if (!this.tableName.equals(other.tableName)) {
            return this.tableName.compareTo(other.tableName);
        }
        if (!this.columnName.equals(other.columnName)) {
            return this.columnName.compareTo(other.columnName);
        }
        return Boolean.compare(this.notNull, other.notNull);
    }

    @Nonnull
    public static Column ofNotNull(@Nonnull String tableName, @Nonnull String columnName) {
        return new Column(tableName, columnName, true);
    }

    @Nonnull
    public static Column ofNullable(@Nonnull String tableName, @Nonnull String columnName) {
        return new Column(tableName, columnName, false);
    }
}

