/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index.utils;

import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class DuplicatedIndexesParser {
    private DuplicatedIndexesParser() {
        throw new UnsupportedOperationException();
    }

    public static List<Map.Entry<String, Long>> parseAsIndexNameAndSize(@Nonnull String duplicatedAsString) {
        Validators.notBlank(duplicatedAsString, "duplicatedAsString");
        String[] indexes = duplicatedAsString.split("; ");
        return Arrays.stream(indexes).map(s -> s.split(",")).filter(a -> a[0].trim().startsWith("idx=") && a[1].trim().startsWith("size=")).map(a -> {
            String indexName = a[0].trim().substring("idx=".length());
            String sizeAsString = a[1].trim().substring("size=".length());
            return Map.entry(indexName, Long.parseLong(sizeAsString));
        }).collect(Collectors.toUnmodifiableList());
    }
}

