/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model;

import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Locale;
import javax.annotation.Nonnull;

public class PgContext {
    public static final int DEFAULT_BLOAT_PERCENTAGE_THRESHOLD = 10;
    public static final String DEFAULT_SCHEMA_NAME = "public";
    private final String schemaName;
    private final int bloatPercentageThreshold;

    private PgContext(@Nonnull String schemaName, int bloatPercentageThreshold) {
        this.schemaName = Validators.notBlank(schemaName, "schemaName").toLowerCase(Locale.ROOT);
        this.bloatPercentageThreshold = Validators.argumentNotNegative(bloatPercentageThreshold, "bloatPercentageThreshold");
    }

    @Nonnull
    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean isDefaultSchema() {
        return DEFAULT_SCHEMA_NAME.equalsIgnoreCase(this.schemaName);
    }

    public int getBloatPercentageThreshold() {
        return this.bloatPercentageThreshold;
    }

    @Nonnull
    public String toString() {
        return PgContext.class.getSimpleName() + "{schemaName='" + this.schemaName + "', bloatPercentageThreshold=" + this.bloatPercentageThreshold + "}";
    }

    @Nonnull
    public String enrichWithSchema(@Nonnull String objectName) {
        Validators.notBlank(objectName, "objectName");
        if (this.isDefaultSchema()) {
            return objectName;
        }
        String prefix = this.schemaName + ".";
        if (objectName.toLowerCase(Locale.ROOT).startsWith(prefix)) {
            return objectName;
        }
        return prefix + objectName;
    }

    @Nonnull
    public static PgContext of(@Nonnull String schemaName, int bloatPercentageThreshold) {
        return new PgContext(schemaName, bloatPercentageThreshold);
    }

    @Nonnull
    public static PgContext of(@Nonnull String schemaName) {
        return PgContext.of(schemaName, 10);
    }

    @Nonnull
    public static PgContext ofPublic() {
        return PgContext.of(DEFAULT_SCHEMA_NAME);
    }
}

