/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.constraint;

import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.constraint.ConstraintType;
import io.github.mfvanek.pg.model.table.TableNameAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Constraint
implements DbObject,
TableNameAware {
    private final String tableName;
    private final String constraintName;
    private final ConstraintType constraintType;

    protected Constraint(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull ConstraintType constraintType) {
        this.tableName = Validators.tableNameNotBlank(tableName);
        this.constraintName = Validators.notBlank(constraintName, "constraintName");
        this.constraintType = Objects.requireNonNull(constraintType, "constraintType cannot be null");
    }

    @Override
    @Nonnull
    public final String getName() {
        return this.getConstraintName();
    }

    @Override
    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Nonnull
    public String getConstraintName() {
        return this.constraintName;
    }

    @Nonnull
    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Constraint)) {
            return false;
        }
        Constraint that = (Constraint)other;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.constraintName, that.constraintName);
    }

    public final int hashCode() {
        return Objects.hash(this.tableName, this.constraintName);
    }

    @Nonnull
    final String innerToString() {
        return "tableName='" + this.tableName + "', constraintName='" + this.constraintName + "'";
    }

    public String toString() {
        return Constraint.class.getSimpleName() + "{" + this.innerToString() + ", constraintType=" + this.constraintType + "}";
    }

    @Nonnull
    public static Constraint ofType(@Nonnull String tableName, @Nonnull String constraintName, @Nonnull ConstraintType constraintType) {
        return new Constraint(tableName, constraintName, constraintType);
    }
}

