/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.constraint;

import java.util.Objects;
import javax.annotation.Nonnull;

public enum ConstraintType {
    CHECK("c"),
    FOREIGN_KEY("f");

    private final String pgConType;

    private ConstraintType(String pgConType) {
        this.pgConType = Objects.requireNonNull(pgConType, "pgConType");
    }

    @Nonnull
    public String getPgConType() {
        return this.pgConType;
    }

    @Nonnull
    public static ConstraintType valueFrom(@Nonnull String pgConType) {
        Objects.requireNonNull(pgConType, "pgConType cannot be null");
        for (ConstraintType ct : ConstraintType.values()) {
            if (!ct.getPgConType().equals(pgConType)) continue;
            return ct;
        }
        throw new IllegalArgumentException("Unknown pgConType: " + pgConType);
    }
}

