/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.index;

import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.index.IndexWithSize;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IndexWithColumns
extends IndexWithSize {
    private final List<Column> columns;

    protected IndexWithColumns(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes, @Nonnull List<Column> columns) {
        super(tableName, indexName, indexSizeInBytes);
        List defensiveCopy = List.copyOf((Collection)Objects.requireNonNull(columns, "columns cannot be null"));
        Validators.validateThatTableIsTheSame(tableName, defensiveCopy);
        this.columns = defensiveCopy;
    }

    @Nonnull
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    @Nonnull
    protected String innerToString() {
        return super.innerToString() + ", columns=" + this.columns;
    }

    @Override
    @Nonnull
    public String toString() {
        return IndexWithColumns.class.getSimpleName() + "{" + this.innerToString() + "}";
    }

    @Nonnull
    public static IndexWithColumns ofSingle(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes, @Nonnull Column column) {
        List<Column> columns = List.of(Objects.requireNonNull(column, "column cannot be null"));
        return new IndexWithColumns(tableName, indexName, indexSizeInBytes, columns);
    }

    @Nonnull
    public static IndexWithColumns ofColumns(@Nonnull String tableName, @Nonnull String indexName, long indexSizeInBytes, @Nonnull List<Column> columns) {
        return new IndexWithColumns(tableName, indexName, indexSizeInBytes, columns);
    }
}

