/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model.table;

import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.table.TableSizeAware;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Table
implements DbObject,
TableSizeAware,
Comparable<Table> {
    private final String tableName;
    private final long tableSizeInBytes;

    private Table(@Nonnull String tableName, long tableSizeInBytes) {
        this.tableName = Validators.tableNameNotBlank(tableName);
        this.tableSizeInBytes = Validators.sizeNotNegative(tableSizeInBytes, "tableSizeInBytes");
    }

    @Override
    @Nonnull
    public final String getName() {
        return this.getTableName();
    }

    @Override
    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public long getTableSizeInBytes() {
        return this.tableSizeInBytes;
    }

    @Nonnull
    final String innerToString() {
        return "tableName='" + this.tableName + "', tableSizeInBytes=" + this.tableSizeInBytes;
    }

    @Nonnull
    public String toString() {
        return Table.class.getSimpleName() + "{" + this.innerToString() + "}";
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Table)) {
            return false;
        }
        Table that = (Table)other;
        return Objects.equals(this.tableName, that.tableName);
    }

    public final int hashCode() {
        return Objects.hash(this.tableName);
    }

    @Override
    public int compareTo(@Nonnull Table other) {
        Objects.requireNonNull(other, "other cannot be null");
        return this.tableName.compareTo(other.tableName);
    }

    @Nonnull
    public static Table of(@Nonnull String tableName, long tableSizeInBytes) {
        return new Table(tableName, tableSizeInBytes);
    }
}

