/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.settings;

import io.github.mfvanek.pg.model.validation.Validators;
import io.github.mfvanek.pg.settings.PgParam;
import io.github.mfvanek.pg.settings.validation.ParamValidators;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PgParamImpl
implements PgParam {
    private final String name;
    private final String value;

    private PgParamImpl(@Nonnull String name, @Nonnull String value) {
        this.name = Validators.notBlank(name, "name");
        this.value = ParamValidators.paramValueNotNull(value, "value for '" + name + "' cannot be null");
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getValue() {
        return this.value;
    }

    @Nonnull
    public String toString() {
        return PgParamImpl.class.getSimpleName() + "{name='" + this.name + "', value='" + this.value + "'}";
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PgParam)) {
            return false;
        }
        PgParam that = (PgParam)other;
        return Objects.equals(this.name, that.getName());
    }

    public final int hashCode() {
        return Objects.hash(this.name);
    }

    public static PgParam of(@Nonnull String name, @Nonnull String value) {
        return new PgParamImpl(name, value);
    }
}

