/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.model;

import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Locale;
import javax.annotation.Nonnull;

public class PgContext {
    public static final double DEFAULT_BLOAT_PERCENTAGE_THRESHOLD = 10.0;
    public static final String DEFAULT_SCHEMA_NAME = "public";
    public static final double DEFAULT_REMAINING_PERCENTAGE_THRESHOLD = 10.0;
    private final String schemaName;
    private final double bloatPercentageThreshold;
    private final double remainingPercentageThreshold;

    private PgContext(@Nonnull String schemaName, double bloatPercentageThreshold, double remainingPercentageThreshold) {
        this.schemaName = Validators.notBlank(schemaName, "schemaName").toLowerCase(Locale.ROOT);
        this.bloatPercentageThreshold = Validators.validPercent(bloatPercentageThreshold, "bloatPercentageThreshold");
        this.remainingPercentageThreshold = Validators.validPercent(remainingPercentageThreshold, "remainingPercentageThreshold");
    }

    @Nonnull
    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean isDefaultSchema() {
        return DEFAULT_SCHEMA_NAME.equalsIgnoreCase(this.schemaName);
    }

    public double getBloatPercentageThreshold() {
        return this.bloatPercentageThreshold;
    }

    public double getRemainingPercentageThreshold() {
        return this.remainingPercentageThreshold;
    }

    @Nonnull
    public String toString() {
        return PgContext.class.getSimpleName() + "{schemaName='" + this.schemaName + "', bloatPercentageThreshold=" + this.bloatPercentageThreshold + ", remainingPercentageThreshold=" + this.remainingPercentageThreshold + "}";
    }

    @Nonnull
    public String enrichWithSchema(@Nonnull String objectName) {
        Validators.notBlank(objectName, "objectName");
        if (this.isDefaultSchema()) {
            return objectName;
        }
        return this.enrichWithSchemaIfNeed(objectName);
    }

    @Nonnull
    public String enrichSequenceWithSchema(@Nonnull String sequenceName) {
        Validators.notBlank(sequenceName, "sequenceName");
        return this.enrichWithSchemaIfNeed(sequenceName);
    }

    @Nonnull
    private String enrichWithSchemaIfNeed(@Nonnull String objectName) {
        String prefix = this.schemaName + ".";
        if (objectName.toLowerCase(Locale.ROOT).startsWith(prefix)) {
            return objectName;
        }
        return prefix + objectName;
    }

    @Nonnull
    public static PgContext of(@Nonnull String schemaName, double bloatPercentageThreshold, double remainingPercentageThreshold) {
        return new PgContext(schemaName, bloatPercentageThreshold, remainingPercentageThreshold);
    }

    @Nonnull
    public static PgContext of(@Nonnull String schemaName, double bloatPercentageThreshold) {
        return new PgContext(schemaName, bloatPercentageThreshold, 10.0);
    }

    @Nonnull
    public static PgContext of(@Nonnull String schemaName) {
        return PgContext.of(schemaName, 10.0);
    }

    @Nonnull
    public static PgContext ofPublic() {
        return PgContext.of(DEFAULT_SCHEMA_NAME);
    }
}

